//JX11RUG4 JOB   (4CKDCN75440,B143),JX11BIND,
//       CLASS=C,MSGCLASS=Q,NOTIFY=JX11,MSGLEVEL=(1,1)
//STEP01  EXEC  SAS6
//MDSIN   DD  DSN=JX11.@DCN7518.RUGS600A.SASLIB,DISP=SHR
//OUTFILE DD DSN=JX11.@DCN7518.RUGS600A.TEXTFIL4,UNIT=HCFA80,
//       DISP=OLD,
//     DCB=(LRECL=80,BLKSIZE=80,RECFM=FB)
//SYSIN   DD  *
OPTIONS  NOCENTER OBS=max;

data  temp1 ;
  set mdsin.mdstest;

************SAS CODE FOR RUG3 VERSION 6.00.09 (58 GROUP MODEL)************   ;
*SAS CODE FOR VERSION 6.00.09 OF THE RUG3 CLASSIFICATION SYSTEM              ;
*                                                                            ;
* Notice: These materials are in the public domain and cannot be copyrighted ;
*                                                                            ;
* Last change:  6/28/2000                                                    ;
*                                                                            ;

*NOTE THAT THIS VERSION EXCLUDES I1d FROM CONSIDERATION.  I1d DOES NOT AFFECT;
*   N_NO.  THE I1d CONDITION HAS BEEN EXCLUDED FROM THE OXYGEN DOMAIN.       ;
                                                                             ;
*Version 6.00 is for use with the MDS Version 2.0 assessment form, and       ;
*  this version implements a new RUG-III model with 58 groups.  This is      ;
*  the original 44 RUG-III groups plus 14 additional groups including        ;
*  MDS assessments that would qualify for for one of the original 14         ;
*  rehabilitation groups and would also qualify for an Extensive Special     ;
*  Care group.  These 58 groups provide the base structure for the new       ;
*  UWIM and WIM2 RUG-III models.                                             ;

*This document contains a long documentation section followed by the         ;
*   actual SAS code.                                                         ;

**************************DOCUMENTATION************************************* ;

*   This SAS code has been placed in a ASCII text file called RUG6_00_01.SAS.;
*      This SAS code is extracted from a working program which received      ;
*      extensive testing.  Two standard RUG-III Version 6.00 test databases  ;
*      with a total of almost 3,000 MDS 2.0 records are available in both    ;
*      DBASE format (TEST600A.DBF and TEST600B.DBF) and ASCII format         ;
*      (TEST600A.ASC and TEST600B.ASC).  These test databases will provide   ;
*      exhaustive testing of 58 group RUG-III classification code.  These    ;
*      test databases are in the national standard format for the MDS 2.0.   ;
*      The national specifications for the MDS 2.0, the present RUG-III SAS  ;
*      code, and the RUG-III Version 6.00 test databases are available on the;
*      HCFA World Wide Web site at the following address:                    ;
*      and Analysis of the University of Wisconsin at Madison.  The address  ;
*           http://www.hcfa.gov/medicaid/mds20/mdssoftw.htm                  ;

*      In the test databases, the T3MDCR field contains RUG-III Version      ;
*      6.00 Special Medicare (hierarchical) type classifications and the     ;
*      T3STATE field contains RUG-III Version 6.00 Hierachical               ;
*      (not Special Medicare) classifications.  The test databases also      ;
*      include intermediate classification variables in the Section S field. ;
*      These intermediate classification results are defined in the code     ;
*      below and their locations in Section S are as follows.                ;

*      Section S Contents in Test Data:                                      ;
*                                                                            ;
*        Binary (0 = No, 1 = Yes) Clinical Hierachy Indicators:              ;
*                                                 Sec S                      ;
*                                                 Start                      ;
*          Name     Qualification For             Position    Length         ;
*          -------  ------------------------      --------    ------         ;
*          n_reh_u  ultra high rehabilitation          1         1           ;
*          n_reh_v  very high rehabilitation           2         1           ;
*          n_reh_h  high rehabilitation                3         1           ;
*          n_reh_m  medium rehabilitation              4         1           ;
*          n_reh_l  low rehabilitation                 5         1           ;
*          n_ext    extensive care                     6         1           ;
*          n_spec   special care                       7         1           ;
*          n_clin   clinically complex                 8         1           ;
*          n_impair impaired cognition                 9         1           ;
*          n_behav  behavior problems                 10         1           ;
*                                                                            ;
*        Other Intermediate Results:                                         ;
*                                                 Sec S                      ;
*                                                 Start                      ;
*          Name     Description                   Position    Length         ;
*          -------  ------------------------      --------    ------         ;
*          n_adlsum RUG-III ADL Index (numeric         11        2           ;
*                     value between 4 and 18)                                ;
*          n_th_min minutes of rehab therapies         12        4           ;
*                     totaled across therapies                               ;
*          n_th_ty3 number of types of rehab           16        1           ;
*                     therapies received 3+ days                             ;
*                     each                                                   ;
*          n_th_ty5 number of types of rehab           17        1           ;
*                     therapies received 5+ days                             ;
*                     each                                                   ;
*          n_th_day number of days of rehab            18        2           ;
*                     therapies totaled across                               ;
*                     therapies                                              ;
*          n_nrsum6 number of nursing rehabilitation   20        2           ;
*                     types on 6+ days each                                  ;
*          n_nrsum2 number of nursing rehabilitation   22        2           ;
*                     types on 2+ days each                                  ;
*          n_depres numeric indicator of depression    24        1           ;
*                     (0 = No, 1 = Yes)                                      ;
*          n_cps    Cognitive Performance Scale code   25        1           ;
*                      with value 0 through 6                                ;
*          n_ext_ct count of number of selected        26        1           ;
*                      hierarchy categories for which                        ;
*                      resident qualifies and selected                       ;
*                      extensive care services (used                         ;
*                      in Extensive Care classifica-                         ;
*                      tion)                                                 ;
*                                                                            ;
*        Ancillary Domian Results:                                           ;
*                                                 Sec S                      ;
*                                                 Start                      ;
*          Name     Description                   Position    Length         ;
*          -------  ------------------------      --------    ------         ;
*          n_ulc4st binary indicator (0/1) for         27        1           ;
*                      the stage 4 ulcer ancillary                           ;
*                      domain                                                ;
*          n_skcar1 binary indicator (0/1) for         28        1           ;
*                      definition 1 for the                                  ;
*                      skin care ancillary domain                            ;
*          n_skcar2 binary indicator (0/1) for         29        1           ;
*                      definition 2 for the                                  ;
*                      skin care ancillary domain                            ;
*          n_skcar3 binary indicator (0/1) for         30        1           ;
*                      definition 3 for the                                  ;
*                      skin care ancillary domain                            ;
*          n_skcar4 binary indicator (0/1) for         31        1           ;
*                      definition 4 for the                                  ;
*                      skin care ancillary domain                            ;
*          n_skcar5 binary indicator (0/1) for         32        1           ;
*                      definition 5 for the                                  ;
*                      skin care ancillary domain                            ;
*          n_ivmed  binary indicator (0/1) for         33        1           ;
*                      IV medication ancillary domain                        ;
*          n_resp   binary indicator (0/1) for         34        1           ;
*                      respiratory infection                                 ;
*                      ancillary domain                                      ;
*          n_trach  binary indicator (0/1) for         35        1           ;
*                      traceostomy care ancillary                            ;
*                      domain                                                ;
*          n_suct   binary indicator (0/1) for         36        1           ;
*                      suctioning ancillary domain                           ;
*          n_pneum  binary indicator (0/1) for         37        1           ;
*                      pneumonia ancillary domain                            ;
*          n_par_iv binary indicator (0/1) for         38        1           ;
*                      parenteral/IV ancillary domain                        ;
*          n_tube   binary indicator (0/1) for         39        1           ;
*                      tube feeding ancillary domain                         ;
*          n_oxygen binary indicator (0/1) for         40        1           ;
*                      oxygen ancillary domain                               ;
*          n_dress1 binary indicator (0/1) for         41        1           ;
*                      definition 1 for the                                  ;
*                      dressings ancillary domain                            ;
*          n_dress2 binary indicator (0/1) for         42        1           ;
*                      definition 2 for the                                  ;
*                      dressings ancillary domain                            ;
*          n_dress3 binary indicator (0/1) for         43        1           ;
*                      definition 3 for the                                  ;
*                      dressings ancillary domain                            ;
*          n_dress4 binary indicator (0/1) for         44        1           ;
*                      definition 4 for the                                  ;
*                      dressings ancillary domain                            ;

*--------------------------------------------------------------------------- ;
*CALCULATION TYPES (MODES) USED IN THIS SAS code:                            ;

*   This SAS code allows 58 group RUG-III classification using 1) the        ;
*   Hierarchical and Index maximizing types, or 2) the Special Medicare and  ;
*   the Index maximizing Special Medicare calculation types.                 ;
*                                                                            ;
*   For the Hierarchical type, a resident is placed in the first group       ;
*   for which they qualify.  The order of precedence of the groups is        ;
*   Ultra High Rehabilitation, Very High Rehabilitation, High Rehabilitation,;
*   Medium Rehabilitation, Low Rehabilitation, Extensive Care, Special Care, ;
*   Clinically Complex, Cognitively Impaired, Behavior Problems, and Reduced ;
*   Physical Function.                                                       ;
                                                                             ;
*   For the Index maximizing calculation type, there is no order of          ;
*   precedence  for the groups.  For this latter method, all groups for      ;
*   which a resident would qualify are determined, and the resident is       ;
*   placed in the group with the highest CMI (Case Mix Index).  If the       ;
*   Index maximizing method is used, then a CMI set must be provided (this   ;
*   CMI set is assumed to be loaded into an array named n_cmi and the        ;
*   ordering of the elements in this array is given later in this            ;
*   documentation).                                                          ;
                                                                             ;
*   The Special Medicare calculation type is hierarchical and                ;
*   applies special rehabilitation group classification for Medicare         ;
*   assessments which are 5-day preliminary assessments (AA8b = '1') or      ;
*   readmission assessments (AA8b = '5').  For these two types of assessments;
*   the Medicare method considers rehabilitation therapies ordered (items    ;
*   T1b, T1c, and T1d) in addition to rehabilitation therapies actually      ;
*   provided.                                                                ;
                                                                             ;
*   The Index maximizing Special Medicare calculation type combines index    ;
*   maximizing with the Special Medicare rehabilitation grouping.            ;
                                                                             ;
*   The calculation type is determined by the value of variable c_type.      ;
*        IF c_type = 'SMcare', then the hierarchical and index maximized     ;
*           groupings will be produced using the Special Medicare logic.     ;
*        If c_type = any other value, then the Standard hierarchical and     ;
*                    index maximizing groupings will be produced.            ;
*--------------------------------------------------------------------------- ;
*RUG-III GROUP LABELS AND ORDER OF GROUPS IN CMI ARRAY:                      ;

*   Order for the CMI (n_cmi) array is as follows:                           ;

*      Array                                                                 ;
*    Element #   RUG-III Group                                               ;
*    ---------   -------------                                               ;
*        1       XUC:  Extens.&Rehab. Ultra High / ADL 16 - 18               ;
*        2       XUB:  Extens.&Rehab. Ultra High / ADL  9 - 15               ;
*        3       XUA:  Extens.&Rehab. Ultra High / ADL  4 -  8               ;
*        4       XVC:  Extens.&Rehab. Very High / ADL 16 - 18                ;
*        5       XVB:  Extens.&Rehab. Very High / ADL  9 - 15                ;
*        6       XVA:  Extens.&Rehab. Very High / ADL  4 -  8                ;
*        7       XHC:  Extens.&Rehab. High / ADL 13 - 18                     ;
*        8       XHB:  Extens.&Rehab. High / ADL  8 - 12                     ;
*        9       XHA:  Extens.&Rehab. High / ADL  4 -  7                     ;
*       10       XMC:  Extens.&Rehab. Medium / ADL 15 - 18                   ;
*       11       XMB:  Extens.&Rehab. Medium / ADL  8 - 14                   ;
*       12       XMA:  Extens.&Rehab. Medium / ADL  4 -  7                   ;
*       13       XLB:  Extens.&Rehab. Low / ADL 14 - 18                      ;
*       14       XLA:  Extens.&Rehab. Low / ADL  4 - 13                      ;
*       15       RUC:  Rehabilitation Ultra High / ADL 16 - 18               ;
*       16       RUB:  Rehabilitation Ultra High / ADL  9 - 15               ;
*       17       RUA:  Rehabilitation Ultra High / ADL  4 -  8               ;
*       18       RVC:  Rehabilitation Very High / ADL 16 - 18                ;
*       19       RVB:  Rehabilitation Very High / ADL  9 - 15                ;
*       20       RVA:  Rehabilitation Very High / ADL  4 -  8                ;
*       21       RHC:  Rehabilitation High / ADL 13 - 18                     ;
*       22       RHB:  Rehabilitation High / ADL  8 - 12                     ;
*       23       RHA:  Rehabilitation High / ADL  4 -  7                     ;
*       24       RMC:  Rehabilitation Medium / ADL 15 - 18                   ;
*       25       RMB:  Rehabilitation Medium / ADL  8 - 14                   ;
*       26       RMA:  Rehabilitation Medium / ADL  4 -  7                   ;
*       27       RLB:  Rehabilitation Low / ADL 14 - 18                      ;
*       28       RLA:  Rehabilitation Low / ADL  4 - 13                      ;
*       29       SE3:  Extensive Special Care 3 / ADL > 6                    ;
*       30       SE2:  Extensive Special Care 2 / ADL > 6                    ;
*       31       SE1:  Extensive Special Care 1 / ADL > 6                    ;
*       32       SSC:  Special Care / ADL 17 - 18                            ;
*       33       SSB:  Special Care / ADL 15 - 16                            ;
*       34       SSA:  Special Care / ADL  4 - 14                            ;
*       35       CC2:  Clin. Complex with Depression / ADL 17 - 18           ;
*       36       CC1:  Clinically Complex / ADL 17 - 18                      ;
*       37       CB2:  Clin. Complex with Depression / ADL 12 - 16           ;
*       38       CB1:  Clinically Complex / ADL 12 - 16                      ;
*       39       CA2:  Clin. Complex with Depression / ADL  4 - 11           ;
*       40       CA1:  Clinically Complex / ADL  4 - 11                      ;
*       41       IB2:  Cog. Impairment with Nursing Rehab / ADL   6 - 10     ;
*       42       IB1:  Cognitive Impairment / ADL   6 - 10                   ;
*       43       IA2:  Cog. Impairment with Nursing Rehab / ADL   4 -  5     ;
*       44       IA1:  Cognitive Impairment / ADL   4 -  5                   ;
*       45       BB2:  Behavior Problem with Nursing Rehab / ADL 6 - 10      ;
*       46       BB1:  Behavior Problem / ADL   6 - 10                       ;
*       47       BA2:  Behavior Problem with Nursing Rehab / ADL 4 -  5      ;
*       48       BA1:  Behavior Problem / ADL   4 -  5                       ;
*       49       PE2:  Physical Function with Nursing Rehab / ADL  16 - 18   ;
*       50       PE1:  Physical Function / ADL  16 - 18                      ;
*       51       PD2:  Physical Function with Nursing Rehab / ADL  11 - 15   ;
*       52       PD1:  Physical Function / ADL  11 - 15                      ;
*       53       PC2:  Physical Function with Nursing Rehab / ADL   9 - 10   ;
*       54       PC1:  Physical Function / ADL   9 - 10                      ;
*       55       PB2:  Physical Function with Nursing Rehab / ADL   6 -  8   ;
*       56       PB1:  Physical Function / ADL   6 -  8                      ;
*       57       PA2:  Physical Function with Nursing Rehab / ADL   4 -  5   ;
*       58       PA1:  Physical Function / ADL   4 -  5                      ;
*       59       BC1:  RUG_III group not calculated due to data errors       ;

*--------------------------------------------------------------------------- ;
*SYNTAX USED IN THIS  SAS  CODE:                                             ;
                                                                             ;
*   1.  All lines with an asterisk (*) as the first nonblank character in    ;
*         the line are documentation or comment lines.  All command lines    ;
*         start with a character other than an asterisk.                     ;
*   2.  A semicolon indicates the end of a statement in the SAS code used    ;
*         here, while in Clipper a semicolon would be used as a continuation ;
*         character.                                                         ;
*   3.  All variables are represented in small letters, while command        ;
*         words are represented in capital letters.                          ;
*   4.  All MDS 2.0 variables are represented in small letters as specified  ;
*         in the Uniform Data Submission Specifications for the MDS 2.0.     ;
*         ALL MDS 2.0 VARIABLES ARE REQUIRED TO BE CHARACTER VARIABLES       ;
*         IN THIS SAS CODE.  The MDS 2.0 variables names correspond to the   ;
*         labels on the MDS 2.0 form.                                        ;
*   5.  All local (non-MDS) variables are represented in small letters with  ;
*         a prefix of "c_" for character variables (e.g., c_type) and        ;
*         a prefix of "n_" for numeric variables (e.g., n_adlsum)            ;
*   6.  The only command words and structures used in this SAS code are:     ;
*         a. RETURN                                                          ;
*               (this command causes the end of processing the current record;
*               and initiation of processing the next record)                ;
*         b. %INCLUDE 'filename' /SOURCE2                                    ;
*              (adds statements in external file to a SAS program)           ;
*         c. IF <logical condition1>                                         ;
*              THEN <arithmetic statement> executed if condition1 true       ;
*            ELSE IF <logical condition2>                                    ;
*              THEN <arithmetic statement> executed if condition2 true       ;
*                DO <multiple statements>  END                               ;
*            ELSE   <arithmetic statement> executed if no condition is true  ;
*         c. Logical operators used in logical conditions are                ;
*                =       (equal)                                             ;
*                >       (greater than)                                      ;
*                <       (less than)                                         ;
*                >=      (greater than or equal to)                          ;
*                <=      (less than or equal to)                             ;
*                NE      (not equal to)                                      ;
*         d. Relational operators used in logical conditions are             ;
*                 AND    (logical and)        NOT (logical not)              ;
*                 OR     (logical or)                                        ;
*         e. INPUT(c_var,#.) -- the input function used with a numeric format;
*                 returns the numeric value for a character variable (c_var).;
*   7.  Nested IF structures are indented for clarity.                       ;
*   8.  Single quotes (') delimit a character constant.                      ;
*--------------------------------------------------------------------------- ;
*PRE-PROCESSING REQUIRED BEFORE EXECUTION OF SAS code:                       ;

*   1.  Read MDS 2.0 record and store appropriate character values in the    ;
*          MDS 2.0 variables listed below.                                   ;
*   2.  Scan each required MDS 2.0 variable for valid value (valid values for;
*          each variable are given below).  If an invalid value occurs for   ;
*          ANY required MDS 2.0 variable, then the default RUG-III class is  ;
*          assigned (BC1) and the RUG-III calculation code in this document  ;
*          is skipped.                                                       ;

*--------------------------------------------------------------------------- ;
*MDS 2.0 ITEMS USED IN THIS SAS code:                                        ;

*All MDS 2.0 items in the code are referenced by the form location indicated ;
*     in the Uniform Data Submission Specifications for the MDS 2.0.         ;

*The 117 MDS Version 2.0 variables required by the  SAS code for RUG-III     ;
*  classification are given below.  For each variable, the MDS 2.0 item      ;
*  label, allowable range of values, and item description are given.  Please ;
*  see a later section for out-of-range value handling.                      ;

*      ITEM                                                                  ;
*      LABEL   RANGE              DESCRIPTION                                ;
*      -----  ------------------ -------------------------------------       ;
*   1) aa8b   '12345678 '        Special assessment code                     ;
*   2) b1     '01-'              Comatose                                    ;
*   3) b2a    '01- '             Short-term memory OK                        ;
*   4) b4     '0123- '           Cognitive Skills/Daily Decision Making      ;
*   5) c4     '0123- '           Making Self Understood                      ;
*   6) e1a    '012- '            Negative statements                         ;
*   7) e1b    '012- '            Repetitive questions                        ;
*   8) e1c    '012- '            Repetitive verbalizations                   ;
*   9) e1d    '012- '            Persistent anger with self/others           ;
*  10) e1e    '012- '            Self deprecation                            ;
*  11) e1f    '012- '            Expression of unrealistic fears             ;
*  12) e1g    '012- '            Recurrent statements of terrible future     ;
*  13) e1h    '012- '            Repetitive health complaints                ;
*  14) e1i    '012- '            Repetitive anxious complaints/concerns      ;
*  15) e1j    '012- '            Unpleasant mood in morning                  ;
*  16) e1k    '012- '            Insomnia/change in sleeping pattern         ;
*  17) e1l    '012- '            Sad/pained/worried facial expressions       ;
*  18) e1m    '012- '            Crying/tearfulness                          ;
*  19) e1n    '012- '            Repetitive physical movements               ;
*  20) e1o    '012- '            Withdrawal from activities of interest      ;
*  21) e1p    '012- '            Reduced social interaction                  ;
*  22) e4aa   '0123- '           Behavior symptom frequency                  ;
*  23) e4ba   '0123- '           Behavior symptom frequency                  ;
*  24) e4ca   '0123- '           Behavior symptom frequency                  ;
*  25) e4da   '0123- '           Behavior symptom frequency                  ;
*  26) e4ea   '0123- '           Behavior symptom frequency                  ;
*  27) g1aa   '012348-'          ADL Self-Performance                        ;
*  28) g1ab   '01238-'           ADL Support Provided                        ;
*  29) g1ba   '012348-'          ADL Self-Performance                        ;
*  30) g1bb   '01238-'           ADL Support Provided                        ;
*  31) g1ha   '012348-'          ADL Self-Performance                        ;
*  32) g1ia   '012348-'          ADL Self-Performance                        ;
*  33) g1ib   '01238-'           ADL Support Provided                        ;
*  34) h3a    '01-'              Any scheduled toileting plan                ;
*  35) h3b    '01-'              Bladder retraining program                  ;
*  36) i1a    '01-'              Diabetes mellitus                           ;
*  37) i1r    '01-'              Aphasia                                     ;
*  38) i1s    '01-'              Cerebral palsy                              ;
*  39) i1v    '01-'              Hemiplegia/hemiparesis                      ;
*  40) i1w    '01-'              Multiple sclerosis                          ;
*  41) i1z    '01-'              Quadriplegia                                ;
*  42) i2e    '01-'              Pneumonia                                   ;
*  43) i2g    '01-'              Septicemia                                  ;
*  44) j1c    '01-'              Dehydrated--output exceeds input            ;
*  45) j1e    '01-'              Delusions                                   ;
*  46) j1h    '01-'              Fever                                       ;
*  47) j1i    '01-'              Hallucinations                              ;
*  48) j1j    '01-'              Internal bleeding                           ;
*  49) j1o    '01-'              Vomiting                                    ;
*  50) k3a    '01-'              Weight loss                                 ;
*  51) k5a    '01-'              Parenteral IV                               ;
*  52) k5b    '01-'              Feeding tube                                ;
*  53) k6a    '01234- '          Total calories (%) received in last 7 days  ;
*  54) k6b    '012345- '         Average fluid intake (daily) in last 7 days ;
*  55) m1a    '0123456789-'      Stage 1                                     ;
*  56) m1b    '0123456789-'      Stage 2                                     ;
*  57) m1c    '0123456789-'      Stage 3                                     ;
*  58) m1d    '0123456789-'      Stage 4                                     ;
*  59) m2a    '01234-'           Pressure ulcer                              ;
*  60) m4b    '01-'              Burns (second or third degree)              ;
*  61) m4c    '01-'              Open lesions other than ulcers, rashes, cuts;
*  62) m4g    '01-'              Surgical wounds                             ;
*  63) m5a    '01-'              Pressure relieving device(s) for chair      ;
*  64) m5b    '01-'              Pressure relieving device(s) for bed        ;
*  65) m5c    '01-'              Turning/repositioning program               ;
*  66) m5d    '01-'              Nutrition/hydration intervention            ;
*  67) m5e    '01-'              Ulcer care                                  ;
*  68) m5f    '01-'              Surgical wound care                         ;
*  69) m5g    '01-'              Application of dressings                    ;
*  70) m5h    '01-'              Application of ointments/medications        ;
*  71) m6b    '01-'              Infection of foot--e.g.,cellulitis, etc.    ;
*  72) m6c    '01-'              Open lesions on foot                        ;
*  73) m6f    '01-'              Application of dressings (foot)             ;
*  74) n1a    '01-'              Morning                                     ;
*  75) n1b    '01-'              Afternoon                                   ;
*  76) n1c    '01-'              Evening                                     ;
*  77) o3     '01234567-'        Injections (number days)                    ;
*  78) p1aa   '01-'              Chemotherapy                                ;
*  79) p1ab   '01-'              Dialysis                                    ;
*  80) p1ac   '01-'              IV medication                               ;
*  81) p1ag   '01-'              Oxygen therapy                              ;
*  82) p1ah   '01-'              Radiation                                   ;
*  83) p1ai   '01-'              Suctioning                                  ;
*  84) p1aj   '01-'              Tracheostomy care                           ;
*  85) p1ak   '01-'              Transfusions                                ;
*  86) p1al   '01-'              Ventilator or respirator                    ;
*  87) p1baa  '01234567-'        # days for 15 min. or more (last 7 days)    ;
*  88) p1bab  '0000' thru '9999' total # minutes (last 7 day)                ;
*                or '----'                                                   ;
*  89) p1bba  '01234567-'        # days for 15 min. or more (last 7 days)    ;
*  90) p1bbb  '0000' thru '9999' total # minutes (last 7 day)                ;
*                or '----'                                                   ;
*  91) p1bca  '01234567-'        # days for 15 min. or more (last 7 days)    ;
*  92) p1bcb  '0000' thru '9999' total # minutes (last 7 day)                ;
*                or '----'                                                   ;
*  93) p1bda  '01234567-'        # days for 15 min. or more (last 7 days)    ;
*  94) p3a    '01234567-'        Range of motion (passive)                   ;
*  95) p3b    '01234567-'        Range of motion (active)                    ;
*  96) p3c    '01234567-'        Splint or brace assistance                  ;
*  97) p3d    '01234567-'        Bed mobility                                ;
*  98) p3e    '01234567-'        Transfer                                    ;
*  99) p3f    '01234567-'        Walking                                     ;
* 100) p3g    '01234567-'        Dressing or grooming                        ;
* 101) p3h    '01234567-'        Eating or swallowing                        ;
* 102) p3i    '01234567-'        Amputation/prosthesis care                  ;
* 103) p3j    '01234567-'        Communication                               ;
* 104) p7     '00' thru '14'     Physician Visits                            ;
*                or '--'                                                     ;
* 105) p8     '00' thru '14'     Physician Orders                            ;
*                or '--'                                                     ;
* 106) t1b    '01- '             Ordered Therapies                           ;
* 107) t1c    '00' thru '15'     Estimate of days of therapy until day 15    ;
*                or '--'                                                     ;
*                or blank                                                    ;
* 108) t1d    '0000' thru '9999' Estimate of minutes of therapy until day 15 ;
*                or '----'                                                   ;
*                or blank                                                    ;
*Additional variables needed to calculate the ancillary domains:             ;
*NOTE I1d NOT USED IN THIS VERSION.                                          ;
* 109) i1d    '01-'              Aretriosclerotic heart disease              ;
* 110) i1f    '01-'              Congestive heart failure                    ;
* 111) 11ii   '01-'              Emphysema/COPD                              ;
* 112) i2f    '01-'              Respiatory infection                        ;
* 113) j1L    '01-'              Shortness of breath                         ;
* 114) m4a    '01-'              Abrasions, bruises                          ;
* 115) m4d    '01-'              Rashes                                      ;
* 116) m4e    '01-'              Skin desentitized to pain or pressure       ;
* 117) m4f    '01-'              Skin tears or cuts (not surgery)            ;

*--------------------------------------------------------------------------- ;
*HANDLING OF OUT-OF-RANGE VALUES FOR MDS 2.0 ITEMS:                          ;

*Before execution of RUG-III classification using this SAS code, it is       ;
*  required that all 117 MDS 2.0 items be scanned for valid ranges using     ;
*  the ranges given in the list above.  The RUG-III standard for range       ;
*  checking is to completely skip the logic given in this code and assign a  ;
*  default classification (Group BC1) if ANY one of the 117 MDS 2.0 items is ;
*  out-of-range for a record.                                                ;

*If an out-of-range values occurs for ANY of the 117 MDS 2.0 items, then     ;
*  this code will return a default RUG-III classification of BC1 and         ;
*  determination of all clinical category indicators, ancillary domain       ;
*  indicators, and intermediate computed values will be skipped--the values  ;
*  for all these indicators and computations will simply be set to 0 (zero). ;
*  When the classification is the BC1 default, the values of all of these    ;
*  indicators and intermediate calculations should be ignored.               ;

*The allowable ranges given above correspond to MDS 2.0 national             ;
*  specifications.  Note that a standard HCFA quarterly assessment is a      ;
*  partial 2 page assessment which does not include several of the items     ;
*  that are used for RUG-III classification.  If an MDS quarterly            ;
*  assessment record is the standard HCFA partial quarterly, then that       ;
*  assessment will always result in a default classification (BC1) unless    ;
*  the additional, required RUG-III items have been added to the record.     ;
*  RUG-III classification requires that all 117 items be available.          ;

*Researchers may be interested in a best guess RUG-III classification even   ;
*  when missing (out-of-range) values are present.  The present code         ;
*  can be used for those purposes in the following manner:                   ;
*    1) Omit out-of-range grouping skip, recoding invalid values if desired. ;
*    2) Time awake check boxes (n1a, n1b, n1c) must be 0 rather than blank.  ;
*    3) Any Adl support variables used by the grouper (g1ab, g1bb, g1ib) of  ;
*       value ampersand (&) should be recoded to dash (-) filled.            ;
*    4) Then execute the logic given in the SAS code.                        ;

*--------------------------------------------------------------------------- ;
*MDS 2.0 ITEM VALUE RECODING                                                 ;

*Previous versions of RUG-III have required that some recoding of items      ;
*  be performed before using the standard classification logic.  This is     ;
*  not true of version 6.00 (the present version).  The present logic has    ;
*  been written to eliminate the need for all recoding before application of ;
*  the standard logic.                                                       ;

*--------------------------------------------------------------------------- ;
*INPUT VARIABLES USED IN THE CLASSIFICATION LOGIC:                           ;

* VARIABLE       DESCRIPTION                                                 ;

*   n_cmi     is the 59 element array holding the case mix indices for       ;
*                the calculation selected. The first 58 entries are those    ;
*                for the 58 group model, the 59th is for a default grouping  ;
*                (used when data errors do not allow classification).        ;
*   c_type    has a value of "SMcare" if the calculation method is           ;
*                to be special medicare and utilize logic based on ordered   ;
*                therapies. With any other value, the standard classification;
*                occurs. Both a hierarchical group and an index maximized    ;
*                group are produced under each calculation.                  ;

*--------------------------------------------------------------------------- ;
*RESULT VARIABLES PRODUCED BY THE CLASSIFICATION LOGIC:                      ;

* VARIABLE       DESCRIPTION                                                 ;
*   c_rug_hr  is the hierarchical alphabetic RUG-III group                   ;
*   n_rug_hr  the hierarchical numeric (1-58) group for the resident         ;
*   c_rug_mx  is the index maximized alphabetic RUG-III group                ;

*---------------------------------------------------------------------------
*INTERMEDIATE VARIABLES CREATED FOR USE IN THE CLASSIFICATION LOGIC:         ;

*Numeric Indicators for qualification in RUG-III clinical categories.  *     ;
*  For each of these indicators a 0 (zero) indicates not qualified     *     ;
*  and a 1 indicates qualified for the category.                       *     ;
*      n_reh_u   - ultra high rehabilitation                           *     ;
*      n_reh_v   - very high rehabilitation                            *     ;
*      n_reh_h   - high rehabilitation                                 *     ;
*      n_reh_m   - medium rehabilitation                               *     ;
*      n_reh_l   - low rehabilitation                                  *     ;
*      n_ext     - extensive care                                      *     ;
*      n_spec    - special care                                        *     ;
*      n_clin    - clinically complex                                  *     ;
*      n_impair  - impaired cognition                                  *     ;
*      n_behav   - behavior problems                                   *     ;
*                                                                      *     ;
*Other variables used in computations:                                 *     ;
*      n_bedmb  - numeric recode of bed mobility ADL                   *     ;
*      n_trans  - numeric recode of transfer ADL                       *     ;
*      n_toilt  - numeric recode of toileting ADL                      *     ;
*      n_intake - numeric indicator for parenteral/enteral intake level*     ;
*      n_eatng  - numeric recode of eating ADL                         *     ;
*      n_adlsum - RUG-III ADL Index (numeric value between 4 and 18)   *     ;
*      n_th_min - minutes of rehab therapies totaled across therapies  *     ;
*      n_th_ty3 - number of types of rehab therapies received 3+ days  *     ;
*                    each                                              *     ;
*      n_th_ty5 - number of types of rehab therapies received 5+ days  *     ;
*                    each                                              *     ;
*      n_th_day - number of days of rehab therapies totaled across     *     ;
*                    therapies                                         *     ;
*      n_nrsum6 - number of nursing rehabilitation types on 6+ days    *     ;
*                    each                                              *     ;
*      n_nrsum2 - number of nursing rehabilitation types on 2+ days    *     ;
*                    each                                              *     ;
*      n_t1c    - numeric value of expected days of rehab therapy      *     ;
*      n_t1d    - numeric value of expected minutes of rehab therapy   *     ;
*      n_ulcer  - numeric count of number of ulcers, all levels        *     ;
*      n_sk_tr  - numeric count of selected skin treatments            *     ;
*      n_n_awak - numeric count of periods that the resident is not    *     ;
*                 awake                                                *     ;
*      n_p7     - numerical version of p7 (MD visits) for ease of      *     ;
*                 coding                                               *     ;
*      n_p8     - numerical value of p8 (MD orders) for ease of        *     ;
*                 coding                                               *     ;
*      n_mood   - numeric count of mood indicators                     *     ;
*      n_depres - numeric indicator of depression                      *     ;
*      n_coma   - numeric indicator of coma with selected qualifiers   *     ;
*      n_cog1   - numeric count of selected cognitive problems for     *     ;
*                 Cognitive Performance Scale                          *     ;
*      n_cog2   - second numeric count of selected cognitive problems  *     ;
*                 for Cognitive Performance Scale                      *     ;
*      n_cps    - numeric Cognitive Performance Scale code             *     ;
*      n_ext_ct - count of number of selected hierarchy categories     *     ;
*                 for which resident qualifies and selected extensive  *     ;
*                 care services (used in Extensive Care classification)*     ;
*      n_no     - signals existence of invalid values for classifying  *     ;
*                                                                      *     ;
*Numeric Indicators for qualification in RUG-III clinical categories.  *     ;
*  For each of these indicators a 0 (zero) indicates not qualified     *     ;
*  and a 1 indicates qualified for the category.                       *     ;
*      n_ulc4st - binary indicator (0/1) for stage 4 ulcer ancillary   *     ;
*                 domain                                               *     ;
*      n_skcar1 - binary indicator (0/1) for definition 1 for the      *     ;
*                 skin care ancillary domain                           *     ;
*      n_skcar2 - binary indicator (0/1) for definition 2 for the      *     ;
*                 skin care ancillary domain                           *     ;
*      n_skcar3 - binary indicator (0/1) for definition 3 for the      *     ;
*                 skin care ancillary domain                           *     ;
*      n_skcar4 - binary indicator (0/1) for definition 4 for the      *     ;
*                 skin care ancillary domain                           *     ;
*      n_skcar5 - binary indicator (0/1) for definition 5 for the      *     ;
*                 skin care ancillary domain                           *     ;
*      n_ivmed  - binary indicator (0/1) for IV medication ancillary   *     ;
*                 domain                                               *     ;
*      n_resp   - binary indicator (0/1) for respiratory infection     *     ;
*                 ancillary domain                                     *     ;
*      n_trach  - binary indicator (0/1) for traceostomy care ancillary*     ;
*                 domain                                               *     ;
*      n_suct   - binary indicator (0/1) for suctioning ancillary      *     ;
*                 domain                                               *     ;
*      n_pneum  - binary indicator (0/1) for pneumonia ancillary domain*     ;
*      n_par_iv - binary indicator (0/1) for parenteral/IV ancillary   *     ;
*                 domain                                               *     ;
*      n_tube   - binary indicator (0/1) for tube feeding ancillary    *     ;
*                 domain                                               *     ;
*      n_oxygen - binary indicator (0/1) for oxygen ancillary domain   *     ;
*      n_dress1 - binary indicator (0/1) for definition 1 for the      *     ;
*                      dressings ancillary domain                      *     ;
*      n_dress2 - binary indicator (0/1) for definition 2 for the      *     ;
*                      dressings ancillary domain                      *     ;
*      n_dress3 - binary indicator (0/1) for definition 3 for the      *     ;
*                      dressings ancillary domain                      *     ;
*      n_dress4 - binary indicator (0/1) for definition 4 for the      *     ;
*                      dressings ancillary domain                      *     ;

************************************************************************     ;
*CODE ORGANIZATION:                                                          ;

*Version 6.00 employs a 2 stage process involving a clinical qualification   ;
*  stage followed by a classification stage as follows:                      ;
*      1.  Clinical Qualification Stage.  Determine all of RUG-III clinical  ;
*          categories (Extensive/Ultra High Rehab, Extensive/Very High Rehab,:
*          Extensive/High Rehab, Extensive/Medium Rehab,                     ;
*          Extensive/Low Rehab, Ultra High Rehab, Very High Rehab,           ;
*          High Rehab, Medium Rehab, Low Rehab, Extensive Special Care,      ;
*          Special Care, Clinically Complex, Cognitive Impairment, and       ;
*          Behavior Problems) for which a resident qualifies.  Also          ;
*          determine qualification for each of the 11 ancillary domains.     ;
*          This first stage involves Step I through Step XI in the code      ;
*          below.                                                            ;
*      2.  Classification Stage. Scan all of the qualifications for a        ;
*          resident and classify the resident into a single clinical         ;
*          category using an hierarchical or index maximizing methodology    ;
*          and then classify the resident into one of the RUG-III groups     ;
*          contained in that clinical category.  This second stage involves  ;
*          Step XII in the code.                                             ;

*The RUG-III 6.00 classifies a resident into the Extensive Special Care      ;
*  groups based on consideration of not only qualification for the Extensive ;
*  Special Care clinical category, but also qualification for the Special    ;
*  Care, Clinically Complex, and Cognitive Impairment Clinical categories.   ;
*  This feature necessitates the two stage process.                          ;
*                                                                            ;
*The RUG-III 6.00 classifies a resident into the Extensive & Rehabilitation  ;
*  groups based on consideration of not only qualification for               ;
*  Rehabilitation groups but also the Extensive Special Care groups.  This   ;
*  feature also necessitates the two stage process.                          ;

************************************************************************     ;
*DEVELOPMENT HISTORY:                                                        ;

*   SAS Code           07/27/95 by MLG 07/27/95 - write code for MDS 2.0     ;
*   SAS Revised        11/03/95 by BEF - add comments, format                ;
*   CLIPPER/Pseudocode 03/27/96 by BG  - converted for MDS 2.0               ;
*   SAS Revised        08/03/96 by MLG - added revisions to Upper Hierarchy  ;
*   SAS Revised        08/04/96 by BEF - added revisions to Lower Hierarchy  ;
*   SAS Revised        09/06/96 by BEF - added revisions to ADL splits, etc. ;
*   SAS Revised        09/08/96 by BEF - fixed numbering of Complex group    ;
*   SAS Revised        09/11/96 by BEF - new definition of depression        ;
*   CLIPPER/Pseudocode 11/15/96 by BG  - converted from SAS and M3PI         ;
*                                        payment features added              ;
*   SAS Code           12/01/96 by MG  - SAS code parallel to 5.10 Clipper   ;
*   SAS Code           05/27/00 by BG  - SAS code for 6.00                   ;
************************************************************************     ;

**************************END OF DOCUMENTATION****************************** ;
*************************BEGINNING OF SAS CODE****************************** ;

*Initialize possible outputs before range checking                           ;
c_rug_hr = 'BC1';
n_reh_u  = 0;
n_reh_v  = 0;
n_reh_h  = 0;
n_reh_m  = 0;
n_reh_l  = 0;
n_ext    = 0;
n_spec   = 0;
n_clin   = 0;
n_impair = 0;
n_behav  = 0;
n_bedmb  = 0;
n_trans  = 0;
n_toilt  = 0;
n_intake = 0;
n_eatng  = 0;
n_adlsum = 0;
n_th_min = 0;
n_th_ty3 = 0;
n_th_ty5 = 0;
n_th_day = 0;
n_nrsum6 = 0;
n_nrsum2 = 0;
n_t1c    = 0;
n_t1d    = 0;
n_ulcer  = 0;
n_sk_tr  = 0;
n_n_awak = 0;
n_p7     = 0;
n_p8     = 0;
n_mood   = 0;
n_depres = 0;
n_coma   = 0;
n_cog1   = 0;
n_cog2   = 0;
n_cps    = 0;
n_ext_ct = 0;
n_ulc4st = 0;
n_skcar1 = 0;
n_skcar2 = 0;
n_skcar3 = 0;
n_skcar4 = 0;
n_skcar5 = 0;
n_ivmed  = 0;
n_resp   = 0;
n_trach  = 0;
n_suct   = 0;
n_pneum  = 0;
n_par_iv = 0;
n_tube   = 0;
n_oxygen = 0;
n_dress1 = 0;
n_dress2 = 0;
n_dress3 = 0;
n_dress4 = 0;

*Initialize n_No, the number of out-of-range values found.                   ;
n_no = 0;

*%INCLUDE 'c:\atg\grp\varlist2.sas' /SOURCE2; * Perform range checks on      ;
*                                               grouper variables            ;

*Perform range checks on RUG-III variables.                                  ;
IF NOT (aa8b = ' ') THEN DO;
   IF aa8b < '1' OR aa8b > '8' THEN n_no = n_no + 1;
END;
IF NOT (b1 = '-') THEN DO;
   IF b1   < '0' OR b1   > '1' THEN n_no = n_no + 1;
END;
IF NOT (b2a = '-' OR b2a = ' ') THEN DO;
   IF b2a   < '0' OR b2a   > '1' THEN n_no = n_no + 1;
END;
IF NOT (b4 = '-' OR b4 = ' ') THEN DO;
   IF b4   < '0' OR b4   > '3' THEN n_no = n_no + 1;
END;
IF NOT (c4 = '-' OR c4 = ' ') THEN DO;
   IF c4   < '0' OR c4   > '3' THEN n_no = n_no + 1;
END;
IF NOT (e1a = '-' OR e1a = ' ') THEN DO;
   IF e1a   < '0' OR e1a   > '2' THEN n_no = n_no + 1;
END;
IF NOT (e1b = '-' OR e1b = ' ') THEN DO;
   IF e1b   < '0' OR e1b   > '2' THEN n_no = n_no + 1;
END;
IF NOT (e1c = '-' OR e1c = ' ') THEN DO;
   IF e1c   < '0' OR e1c   > '2' THEN n_no = n_no + 1;
END;
IF NOT (e1d = '-' OR e1d = ' ') THEN DO;
   IF e1d   < '0' OR e1d   > '2' THEN n_no = n_no + 1;
END;
IF NOT (e1e = '-' OR e1e = ' ') THEN DO;
   IF e1e   < '0' OR e1e   > '2' THEN n_no = n_no + 1;
END;
IF NOT (e1f = '-' OR e1f = ' ') THEN DO;
   IF e1f   < '0' OR e1f   > '2' THEN n_no = n_no + 1;
END;
IF NOT (e1g = '-' OR e1g = ' ') THEN DO;
   IF e1g   < '0' OR e1g   > '2' THEN n_no = n_no + 1;
END;
IF NOT (e1h = '-' OR e1h = ' ') THEN DO;
   IF e1h   < '0' OR e1h   > '2' THEN n_no = n_no + 1;
END;
IF NOT (e1i = '-' OR e1i = ' ') THEN DO;
   IF e1i   < '0' OR e1i   > '2' THEN n_no = n_no + 1;
END;
IF NOT (e1j = '-' OR e1j = ' ') THEN DO;
   IF e1j   < '0' OR e1j   > '2' THEN n_no = n_no + 1;
END;
IF NOT (e1k = '-' OR e1k = ' ') THEN DO;
   IF e1k   < '0' OR e1k   > '2' THEN n_no = n_no + 1;
END;
IF NOT (e1l = '-' OR e1l = ' ') THEN DO;
   IF e1l   < '0' OR e1l   > '2' THEN n_no = n_no + 1;
END;
IF NOT (e1m = '-' OR e1m = ' ') THEN DO;
   IF e1m   < '0' OR e1m   > '2' THEN n_no = n_no + 1;
END;
IF NOT (e1n = '-' OR e1n = ' ') THEN DO;
   IF e1n   < '0' OR e1n   > '2' THEN n_no = n_no + 1;
END;
IF NOT (e1o = '-' OR e1o = ' ') THEN DO;
   IF e1o   < '0' OR e1o   > '2' THEN n_no = n_no + 1;
END;
IF NOT (e1p = '-' OR e1p = ' ') THEN DO;
   IF e1p   < '0' OR e1p   > '2' THEN n_no = n_no + 1;
END;
IF NOT (e4aa = '-' OR e4aa = ' ') THEN DO;
   IF e4aa   < '0' OR e4aa   > '3' THEN n_no = n_no + 1;
END;
IF NOT (e4ba = '-' OR e4ba = ' ') THEN DO;
   IF e4ba   < '0' OR e4ba   > '3' THEN n_no = n_no + 1;
END;
IF NOT (e4ca = '-' OR e4ca = ' ') THEN DO;
   IF e4ca   < '0' OR e4ca   > '3' THEN n_no = n_no + 1;
END;
IF NOT (e4da = '-' OR e4da = ' ') THEN DO;
   IF e4da   < '0' OR e4da   > '3' THEN n_no = n_no + 1;
END;
IF NOT (e4ea = '-' OR e4ea = ' ') THEN DO;
   IF e4ea   < '0' OR e4ea   > '3' THEN n_no = n_no + 1;
END;
IF NOT (g1aa = '-' OR g1aa = '8') THEN DO;
   IF g1aa   < '0' OR g1aa   > '4' THEN n_no = n_no + 1;
END;
IF NOT (g1ab = '-' OR g1ab = '8') THEN DO;
   IF g1ab   < '0' OR g1ab   > '3' THEN n_no = n_no + 1;
END;
IF NOT (g1ba = '-' OR g1ba = '8') THEN DO;
   IF g1ba   < '0' OR g1ba   > '4' THEN n_no = n_no + 1;
END;
IF NOT (g1bb = '-' OR g1bb = '8') THEN DO;
   IF g1bb   < '0' OR g1bb   > '3' THEN n_no = n_no + 1;
END;
IF NOT (g1ha = '-' OR g1ha = '8') THEN DO;
   IF g1ha   < '0' OR g1ha   > '4' THEN n_no = n_no + 1;
END;
IF NOT (g1ia = '-' OR g1ia = '8') THEN DO;
   IF g1ia   < '0' OR g1ia   > '4' THEN n_no = n_no + 1;
END;
IF NOT (g1ib = '-' OR g1ib = '8') THEN DO;
   IF g1ib   < '0' OR g1ib   > '3' THEN n_no = n_no + 1;
END;
IF NOT (h3a = '-') THEN DO;
   IF h3a   < '0' OR h3a   > '1' THEN n_no = n_no + 1;
END;
IF NOT (h3b = '-') THEN DO;
   IF h3b   < '0' OR h3b   > '1' THEN n_no = n_no + 1;
END;
IF NOT (i1a = '-') THEN DO;
   IF i1a   < '0' OR i1a   > '1' THEN n_no = n_no + 1;
END;
IF NOT (i1r = '-') THEN DO;
   IF i1r   < '0' OR i1r   > '1' THEN n_no = n_no + 1;
END;
IF NOT (i1s = '-') THEN DO;
   IF i1s   < '0' OR i1s   > '1' THEN n_no = n_no + 1;
END;
IF NOT (i1v = '-') THEN DO;
   IF i1v   < '0' OR i1v   > '1' THEN n_no = n_no + 1;
END;
IF NOT (i1w = '-') THEN DO;
   IF i1w   < '0' OR i1w   > '1' THEN n_no = n_no + 1;
END;
IF NOT (i1z = '-') THEN DO;
   IF i1z   < '0' OR i1z   > '1' THEN n_no = n_no + 1;
END;
IF NOT (i2e = '-') THEN DO;
   IF i2e   < '0' OR i2e   > '1' THEN n_no = n_no + 1;
END;
IF NOT (i2g = '-') THEN DO;
   IF i2g   < '0' OR i2g   > '1' THEN n_no = n_no + 1;
END;
IF NOT (j1c = '-') THEN DO;
   IF j1c   < '0' OR j1c   > '1' THEN n_no = n_no + 1;
END;
IF NOT (j1e = '-') THEN DO;
   IF j1e   < '0' OR j1e   > '1' THEN n_no = n_no + 1;
END;
IF NOT (j1h = '-') THEN DO;
   IF j1h   < '0' OR j1h   > '1' THEN n_no = n_no + 1;
END;
IF NOT (j1i = '-') THEN DO;
   IF j1i   < '0' OR j1i   > '1' THEN n_no = n_no + 1;
END;
IF NOT (j1j = '-') THEN DO;
   IF j1j   < '0' OR j1j   > '1' THEN n_no = n_no + 1;
END;
IF NOT (j1o = '-') THEN DO;
   IF j1o   < '0' OR j1o   > '1' THEN n_no = n_no + 1;
END;
IF NOT (k3a = '-') THEN DO;
   IF k3a   < '0' OR k3a   > '1' THEN n_no = n_no + 1;
END;
IF NOT (k5a = '-') THEN DO;
   IF k5a   < '0' OR k5a   > '1' THEN n_no = n_no + 1;
END;
IF NOT (k5b = '-') THEN DO;
   IF k5b   < '0' OR k5b   > '1' THEN n_no = n_no + 1;
END;
IF NOT (k6a = '-' OR k6a = ' ') THEN DO;
   IF k6a   < '0' OR k6a   > '4' THEN n_no = n_no + 1;
END;
IF NOT (k6b = '-' OR k6b = ' ') THEN DO;
   IF k6b   < '0' OR k6b   > '5' THEN n_no = n_no + 1;
END;
IF NOT (m1a = '-') THEN DO;
   IF m1a   < '0' OR m1a   > '9' THEN n_no = n_no + 1;
END;
IF NOT (m1b = '-') THEN DO;
   IF m1b   < '0' OR m1b   > '9' THEN n_no = n_no + 1;
END;
IF NOT (m1c = '-') THEN DO;
   IF m1c   < '0' OR m1c   > '9' THEN n_no = n_no + 1;
END;
IF NOT (m1d = '-') THEN DO;
   IF m1d   < '0' OR m1d   > '9' THEN n_no = n_no + 1;
END;
IF NOT (m2a = '-') THEN DO;
   IF m2a   < '0' OR m2a   > '4' THEN n_no = n_no + 1;
END;
IF NOT (m4b = '-') THEN DO;
   IF m4b   < '0' OR m4b   > '1' THEN n_no = n_no + 1;
END;
IF NOT (m4c = '-') THEN DO;
   IF m4c   < '0' OR m4c   > '1' THEN n_no = n_no + 1;
END;
IF NOT (m4g = '-') THEN DO;
   IF m4g   < '0' OR m4g   > '1' THEN n_no = n_no + 1;
END;
IF NOT (m5a = '-') THEN DO;
   IF m5a   < '0' OR m5a   > '1' THEN n_no = n_no + 1;
END;
IF NOT (m5b = '-') THEN DO;
   IF m5b   < '0' OR m5b   > '1' THEN n_no = n_no + 1;
END;
IF NOT (m5c = '-') THEN DO;
   IF m5c   < '0' OR m5c   > '1' THEN n_no = n_no + 1;
END;
IF NOT (m5d = '-') THEN DO;
   IF m5d   < '0' OR m5d   > '1' THEN n_no = n_no + 1;
END;
IF NOT (m5e = '-') THEN DO;
   IF m5e   < '0' OR m5e   > '1' THEN n_no = n_no + 1;
END;
IF NOT (m5f = '-') THEN DO;
   IF m5f   < '0' OR m5f   > '1' THEN n_no = n_no + 1;
END;
IF NOT (m5g = '-') THEN DO;
   IF m5g   < '0' OR m5g   > '1' THEN n_no = n_no + 1;
END;
IF NOT (m5h = '-') THEN DO;
   IF m5h   < '0' OR m5h   > '1' THEN n_no = n_no + 1;
END;
IF NOT (m6b = '-') THEN DO;
   IF m6b   < '0' OR m6b   > '1' THEN n_no = n_no + 1;
END;
IF NOT (m6c = '-') THEN DO;
   IF m6c   < '0' OR m6c   > '1' THEN n_no = n_no + 1;
END;
IF NOT (m6f = '-') THEN DO;
   IF m6f   < '0' OR m6f   > '1' THEN n_no = n_no + 1;
END;
IF NOT (n1a = '-') THEN DO;
   IF n1a   < '0' OR n1a   > '1' THEN n_no = n_no + 1;
END;
IF NOT (n1b = '-') THEN DO;
   IF n1b   < '0' OR n1b   > '1' THEN n_no = n_no + 1;
END;
IF NOT (n1c = '-') THEN DO;
   IF n1c   < '0' OR n1c   > '1' THEN n_no = n_no + 1;
END;
IF NOT (o3 = '-') THEN DO;
   IF o3   < '0' OR o3   > '7' THEN n_no = n_no + 1;
END;
IF NOT (p1aa = '-') THEN DO;
   IF p1aa   < '0' OR p1aa   > '1' THEN n_no = n_no + 1;
END;
IF NOT (p1ab = '-') THEN DO;
   IF p1ab   < '0' OR p1ab   > '1' THEN n_no = n_no + 1;
END;
IF NOT (p1ac = '-') THEN DO;
   IF p1ac   < '0' OR p1ac   > '1' THEN n_no = n_no + 1;
END;
IF NOT (p1ag = '-') THEN DO;
   IF p1ag   < '0' OR p1ag   > '1' THEN n_no = n_no + 1;
END;
IF NOT (p1ah = '-') THEN DO;
   IF p1ah   < '0' OR p1ah   > '1' THEN n_no = n_no + 1;
END;
IF NOT (p1ai = '-') THEN DO;
   IF p1ai   < '0' OR p1ai   > '1' THEN n_no = n_no + 1;
END;
IF NOT (p1aj = '-') THEN DO;
   IF p1aj   < '0' OR p1aj   > '1' THEN n_no = n_no + 1;
END;
IF NOT (p1ak = '-') THEN DO;
   IF p1ak   < '0' OR p1ak   > '1' THEN n_no = n_no + 1;
END;
IF NOT (p1al = '-') THEN DO;
   IF p1al   < '0' OR p1al   > '1' THEN n_no = n_no + 1;
END;
IF NOT (p1baa = '-') THEN DO;
   IF p1baa   < '0' OR p1baa   > '7' THEN n_no = n_no + 1;
END;
IF NOT (p1bab = '----') THEN DO;
   IF      SUBSTR(p1bab,1,1) < '0' OR SUBSTR(p1bab,1,1) > '9'
         THEN n_no = n_no + 1;
   ELSE IF SUBSTR(p1bab,2,1) < '0' OR SUBSTR(p1bab,2,1) > '9'
         THEN n_no = n_no + 1;
   ELSE IF SUBSTR(p1bab,3,1) < '0' OR SUBSTR(p1bab,3,1) > '9'
         THEN n_no = n_no + 1;
   ELSE IF SUBSTR(p1bab,4,1) < '0' OR SUBSTR(p1bab,4,1) > '9'
         THEN n_no = n_no + 1;
END;
IF NOT (p1bba = '-') THEN DO;
   IF p1bba   < '0' OR p1bba   > '7' THEN n_no = n_no + 1;
END;
IF NOT (p1bbb = '----') THEN DO;
   IF      SUBSTR(p1bbb,1,1) < '0' OR SUBSTR(p1bbb,1,1) > '9'
         THEN n_no = n_no + 1;
   ELSE IF SUBSTR(p1bbb,2,1) < '0' OR SUBSTR(p1bbb,2,1) > '9'
         THEN n_no = n_no + 1;
   ELSE IF SUBSTR(p1bbb,3,1) < '0' OR SUBSTR(p1bbb,3,1) > '9'
         THEN n_no = n_no + 1;
   ELSE IF SUBSTR(p1bbb,4,1) < '0' OR SUBSTR(p1bbb,4,1) > '9'
         THEN n_no = n_no + 1;
END;
IF NOT (p1bca = '-') THEN DO;
   IF p1bca   < '0' OR p1bca   > '7' THEN n_no = n_no + 1;
END;
IF NOT (p1bcb = '----') THEN DO;
   IF      SUBSTR(p1bcb,1,1) < '0' OR SUBSTR(p1bcb,1,1) > '9'
         THEN n_no = n_no + 1;
   ELSE IF SUBSTR(p1bcb,2,1) < '0' OR SUBSTR(p1bcb,2,1) > '9'
         THEN n_no = n_no + 1;
   ELSE IF SUBSTR(p1bcb,3,1) < '0' OR SUBSTR(p1bcb,3,1) > '9'
         THEN n_no = n_no + 1;
   ELSE IF SUBSTR(p1bcb,4,1) < '0' OR SUBSTR(p1bcb,4,1) > '9'
         THEN n_no = n_no + 1;
END;
IF NOT (p1bda = '-') THEN DO;
   IF p1bda   < '0' OR p1bda   > '7' THEN n_no = n_no + 1;
END;
IF NOT (p3a = '-') THEN DO;
   IF p3a   < '0' OR p3a   > '7' THEN n_no = n_no + 1;
END;
IF NOT (p3b = '-') THEN DO;
   IF p3b   < '0' OR p3b   > '7' THEN n_no = n_no + 1;
END;
IF NOT (p3c = '-') THEN DO;
   IF p3c   < '0' OR p3c   > '7' THEN n_no = n_no + 1;
END;
IF NOT (p3d = '-') THEN DO;
   IF p3d   < '0' OR p3d   > '7' THEN n_no = n_no + 1;
END;
IF NOT (p3e = '-') THEN DO;
   IF p3e   < '0' OR p3e   > '7' THEN n_no = n_no + 1;
END;
IF NOT (p3f = '-') THEN DO;
   IF p3f   < '0' OR p3f   > '7' THEN n_no = n_no + 1;
END;
IF NOT (p3g = '-') THEN DO;
   IF p3g   < '0' OR p3g   > '7' THEN n_no = n_no + 1;
END;
IF NOT (p3h = '-') THEN DO;
   IF p3h   < '0' OR p3h   > '7' THEN n_no = n_no + 1;
END;
IF NOT (p3i = '-') THEN DO;
   IF p3i   < '0' OR p3i   > '7' THEN n_no = n_no + 1;
END;
IF NOT (p3j = '-') THEN DO;
   IF p3j   < '0' OR p3j   > '7' THEN n_no = n_no + 1;
END;
IF NOT (p7 = '--') THEN DO;
   IF      SUBSTR(p7,1,1) < '0' OR SUBSTR(p7,1,1) > '1'
         THEN n_no = n_no + 1;
   ELSE IF SUBSTR(p7,1,1) = '0' AND (SUBSTR(p7,2,1) < '0'
           OR SUBSTR(p7,2,1) > '9')
              THEN n_no = n_no + 1;
   ELSE IF SUBSTR(p7,1,1) = '1' AND (SUBSTR(p7,2,1) < '0'
           OR SUBSTR(p7,2,1) > '4')
              THEN n_no = n_no + 1;
END;
IF NOT (p8 = '--') THEN DO;
   IF      SUBSTR(p8,1,1) < '0' OR SUBSTR(p8,1,1) > '1'
         THEN n_no = n_no + 1;
   ELSE IF SUBSTR(p8,1,1) = '0' AND (SUBSTR(p8,2,1) < '0'
           OR SUBSTR(p8,2,1) > '9')
              THEN n_no = n_no + 1;
   ELSE IF SUBSTR(p8,1,1) = '1' AND (SUBSTR(p8,2,1) < '0'
           OR SUBSTR(p8,2,1) > '4')
              THEN n_no = n_no + 1;
END;
IF NOT (t1b = '-' OR t1b = ' ') THEN DO;
   IF t1b   < '0' OR t1b   > '1' THEN n_no = n_no + 1;
END;
IF NOT (t1c = '--' OR t1c = '  ') THEN DO;
   IF      SUBSTR(t1c,1,1) < '0' OR SUBSTR(t1c,1,1) > '1'
         THEN n_no = n_no + 1;
   ELSE IF SUBSTR(t1c,1,1) = '0' AND (SUBSTR(t1c,2,1) < '0'
           OR SUBSTR(t1c,2,1) > '9')
              THEN n_no = n_no + 1;
   ELSE IF SUBSTR(t1c,1,1) = '1' AND (SUBSTR(t1c,2,1) < '0'
           OR SUBSTR(t1c,2,1) > '5')
              THEN n_no = n_no + 1;
END;
IF NOT (t1d = '----' OR t1d = '    ') THEN DO;
   IF      SUBSTR(t1d,1,1) < '0' OR SUBSTR(t1d,1,1) > '9'
         THEN n_no = n_no + 1;
   ELSE IF SUBSTR(t1d,2,1) < '0' OR SUBSTR(t1d,2,1) > '9'
         THEN n_no = n_no + 1;
   ELSE IF SUBSTR(t1d,3,1) < '0' OR SUBSTR(t1d,3,1) > '9'
         THEN n_no = n_no + 1;
   ELSE IF SUBSTR(t1d,4,1) < '0' OR SUBSTR(t1d,4,1) > '9'
         THEN n_no = n_no + 1;
END;

*Perform range checks on additional variables needed for the ancillary       ;
*    domains:                                                                ;
*NOTE I1d NOT USED IN THIS VERSION.                                          ;
*IF NOT (i1d = '-') THEN DO;
*   IF i1d   < '0' OR i1d   > '1' THEN n_no = n_no + 1;
*END;
IF NOT (i1f = '-') THEN DO;
   IF i1f   < '0' OR i1f   > '1' THEN n_no = n_no + 1;
END;
IF NOT (i1ii = '-') THEN DO;
   IF i1ii   < '0' OR i1ii   > '1' THEN n_no = n_no + 1;
END;
IF NOT (i2f = '-') THEN DO;
   IF i2f   < '0' OR i2f   > '1' THEN n_no = n_no + 1;
END;
IF NOT (j1L = '-') THEN DO;
   IF j1L   < '0' OR j1L   > '1' THEN n_no = n_no + 1;
END;
IF NOT (m4a = '-') THEN DO;
   IF m4a   < '0' OR m4a   > '1' THEN n_no = n_no + 1;
END;
IF NOT (m4d = '-') THEN DO;
   IF m4d   < '0' OR m4d   > '1' THEN n_no = n_no + 1;
END;
IF NOT (m4e = '-') THEN DO;
   IF m4e   < '0' OR m4e   > '1' THEN n_no = n_no + 1;
END;
IF NOT (m4f = '-') THEN DO;
   IF m4f   < '0' OR m4f   > '1' THEN n_no = n_no + 1;
END;

IF n_no NE 0 THEN RETURN;       * Classify only when all data is within range;
* Can comment out this section on performing range checks to allow grouping  ;
*    with invalid data for research ;

*****************************************                                    ;
*Begin calculation.                     *                                    ;
*****************************************                                    ;

*++++++++++++++++++++++++++++++++++++++++                                    ;
*Step I.  Initialize needed variables.                                       ;
*++++++++++++++++++++++++++++++++++++++++                                    ;
*Initialize final RUG-III group to default group.                            ;
c_rug_hr = 'BC1';
*Initialize c_type. 'SMcare' for special medicare, anything else for standard;
c_type='SMcare';
*Initialize highest RUG-III CMI qualified for to large negative number.      ;
*n_cmi_hi is the highest CMI previously qualified for.                       ;
n_cmi_hi = -99999;

*Read in cmi array for index maximizing as selected in file cmi.sas          ;
*%INCLUDE 'c:\atg\grp\cmi.sas'; * '/SOURCE2';
*%INCLUDE 'f:\ill\cmi.sas'; * '/SOURCE2';

*Setup CMI array and set all elements to 0 for hierarchical classification   ;
ARRAY n_cmi(59);
DO i = 1 to 59;
   n_cmi(i) = 0;
END;

*Initialize clinical category indicators                                     ;
n_reh_u  = 0;
n_reh_v  = 0;
n_reh_h  = 0;
n_reh_m  = 0;
n_reh_l  = 0;
n_ext    = 0;
n_spec   = 0;
n_clin   = 0;
n_impair = 0;
n_behav  = 0;
*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  ;
*Step II. Calculate RUG-III ADL Index.                                       ;
*         The ADL index is required for use in splitting the Rehabilitation, ;
*            Special Care, Clinically Complex, Impaired Cognition, Behavior  ;
*            Problems, and Reduced Physical Function RUG-III clinical        ;
*            categories.  The ADL index requires scoring conversion for      ;
*            4 different ADL's and then summation.                           ;
*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  ;

*ADL scoring conversion for Bed mobility                                     ;
IF      (  g1aa = '-'  OR    g1aa = '0'  OR    g1aa = '1') THEN
              n_bedmb = 1;
ELSE IF (  g1aa =  '2')                                    THEN
              n_bedmb = 3;
ELSE IF (  g1aa = '3'  OR    g1aa = '4'  OR    g1aa = '8') THEN DO;
   IF     (  g1ab = '-'  OR    g1ab = '0'
            OR    g1ab = '1'   OR    g1ab =  '2')          THEN
              n_bedmb = 4;
   ELSE IF (  g1ab = '3'   OR    g1ab = '8')               THEN
              n_bedmb = 5;
   END;


*-------------------------------                                             ;
*ADL scoring conversion for Transfer                                         ;
IF     (  g1ba = '-'  OR    g1ba = '0'  OR    g1ba = '1')  THEN
              n_trans = 1;
ELSE IF (  g1ba =  '2')                                    THEN
              n_trans = 3;
ELSE IF (  g1ba = '3'  OR    g1ba = '4'  OR    g1ba = '8') THEN DO;
   IF     (  g1bb = '-'  OR    g1bb = '0'
            OR    g1bb = '1'  OR    g1bb =  '2')           THEN
              n_trans = 4;
   ELSE IF (  g1bb = '3'   OR    g1bb = '8')               THEN
              n_trans = 5;
   END;


*-------------------------------                                             ;
*ADL scoring conversion for Toilet Use                                       ;
IF     (  g1ia = '-'  OR    g1ia = '0'  OR    g1ia = '1')  THEN
              n_toilt = 1;
ELSE IF (  g1ia =  '2')                                    THEN
              n_toilt = 3;
ELSE IF (  g1ia = '3'  OR    g1ia = '4'  OR    g1ia = '8') THEN DO;
   IF     (  g1ib = '-'  OR    g1ib = '0'
            OR    g1ib = '1'  OR    g1ib =  '2')           THEN
              n_toilt = 4;
   ELSE IF (  g1ib = '3'   OR    g1ib = '8')               THEN
              n_toilt = 5;
   END;


*-------------------------------                                             ;
*Code parenteral\enteral intake level--used for Eating scoring conversion and;
*later for Special Care and Clinically Complex qualification.                ;
*   n_intake = 1 if (1) 51% or more of total calories are received           ;
*                through parenteral/enteral intake (k6a) or (2) 26% to 50%   ;
*                of total calories received through parenteral/enteral       ;
*                intake (k6a) and fluid intake is 501 or more cc per day     ;
*                (k6b).                                                      ;
*   n_intake = 0 if parenteral/enteral intake is at a lower level (including ;
*                none).                                                      ;
n_intake = 0;
IF      (  k6a = '3'  OR    k6a = '4')                                   THEN
           n_intake = 1;
ELSE IF (  k6a = '2')  AND
        (  k6b = '2'  OR    k6b = '3'  OR    k6b = '4'  OR    k6b = '5') THEN
           n_intake = 1;


*ADL scoring conversion for Eating                                           ;
IF     (  k5a = '1')  OR  (  k5b = '1'  AND  n_intake = 1) THEN
          n_eatng = 3;
ELSE IF (  g1ha = '-'  OR    g1ha = '0'  OR    g1ha = '1') THEN
          n_eatng = 1;
ELSE IF (  g1ha = '2')                                     THEN
          n_eatng = 2;
ELSE IF (  g1ha = '3'  OR    g1ha = '4'  OR    g1ha = '8') THEN
          n_eatng = 3;


*-------------------------------                                             ;
*Sum the converted ADL scores to n_adlsum;                                   ;
   n_adlsum = n_bedmb + n_trans + n_toilt + n_eatng;

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++       ;
*Step III. Determine Rehab and Rehab nursing variables needed for            ;
*            Rehab categories.                                               ;

*          Variables needed to determine Rehab clinical hierarchy            ;
*            qualification for Standard rehab classification:                ;
*             - Total minutes of rehab therapy received (n_th_min)           ;
*             - Total number of days of rehab received (n_th_day)            ;
*             - Number of types of rehab therapy (n_th_ty3) received         ;
*                  at 3+ days each                                           ;
*             - Number of types of rehab therapy (n_th_ty5) received         ;
*                  at 5+ days each                                           ;
*             - Number of types of nursing rehab activities (n_nrsum6) at    ;
*                  6+ days each  (Note that n_nrsum6 includes any            ;
*                  scheduled toileting plan or bladder retraining program    ;
*                  as a component.)                                          ;

*          Additional variable needed to determine Rehab clinical hierarchy  ;
*            qualification for Special Medicare rehab classification:        ;
*             - Number of types of nursing rehab activities (n_nrsum2) at    ;
*                  2+ days each  (Note that n_nrsum2 includes any            ;
*                  scheduled toileting plan or bladder retraining program    ;
*                  as a component.)                                          ;
*             - Numeric versions of expected days (t1c) and expected         ;
*                  minutes (t1d) of rehab therapy.                           ;
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++       ;

*-------------------------------                                             ;
*Determine n_th_min -- the number of minutes of rehab therapy received.      ;

n_th_min = 0;

*Add speech therapy minutes unless dash filled (value '----')                ;
IF (  p1bab NE '----')                THEN
   n_th_min = SUM(n_th_min,INPUT(compress(p1bab,'-'),4.));


*Add occupational therapy minutes unless dash filled (value '----')          ;
IF (  p1bbb NE '----')                THEN
   n_th_min = SUM(n_th_min,INPUT( compress( p1bbb,'-'),4.));


*Add physical therapy minutes unless dash filled (value '----')              ;
IF (  p1bcb NE '----')                THEN
   n_th_min = SUM(n_th_min,INPUT(  compress(p1bcb,'-'),4.));


*-------------------------------                                             ;
*Determine n_th_day -- the number of days of rehab therapy received.         ;

n_th_day = 0;

*Add speech therapy days if in valid numeric range                           ;
IF ('1' <=   p1baa  AND    p1baa <= '7')    THEN
   n_th_day = n_th_day + INPUT(  p1baa,1.);


*Add occupational therapy days if in valid numeric range                     ;
IF ('1' <=   p1bba  AND    p1bba <= '7')    THEN
   n_th_day = n_th_day + INPUT(  p1bba,1.);


*Add physical therapy days if in valid numeric range                         ;
IF ('1' <=   p1bca  AND    p1bca <= '7')    THEN
   n_th_day = n_th_day + INPUT(  p1bca,1.);


*-------------------------------                                             ;
*Determine n_th_ty3.                                                         ;
*   n_th_ty3 represents the number of different rehab therapies that         ;
*   were provided on 3 or more days during that period. It is used           ;
*   to determine qualification for Ultra High intensity rehab.               ;

n_th_ty3 = 0;
IF ('3' <=   p1baa  AND    p1baa <= '7')    THEN
   n_th_ty3 = n_th_ty3 + 1;

IF ('3' <=   p1bba  AND    p1bba <= '7')    THEN
   n_th_ty3 = n_th_ty3 + 1;

IF ('3' <=   p1bca  AND    p1bca <= '7')    THEN
   n_th_ty3 = n_th_ty3 + 1;


*-------------------------------                                             ;
*Determine n_th_ty5.                                                         ;
*   n_th_ty5 represents the number of different rehab therapies that         ;
*   were provided on 5 or more days during that period. It is used           ;
*   to determine qualification for Ultra High, Very High and High            ;
*   intensity rehab.                                                         ;

n_th_ty5 = 0;
IF ('5' <=   p1baa  AND    p1baa <= '7')    THEN
   n_th_ty5 = n_th_ty5 + 1;

IF ('5' <=   p1bba  AND    p1bba <= '7')    THEN
   n_th_ty5 = n_th_ty5 + 1;

IF ('5' <=   p1bca  AND    p1bca <= '7')    THEN
   n_th_ty5 = n_th_ty5 + 1;


*-------------------------------                                             ;
*Determine n_nrsum6.                                                         ;
*   n_nrsum6 is a count of the number of types of nursing rehab activities   ;
*   provided at least 6 days per week.  Note that a scheduled toileting      ;
*   plan or bladder retraining program is included in this count.            ;

n_nrsum6 = 0;

*Add 1 for passive range of motion (p3a) or active range of motion (p3b)     ;
IF (('6' <=   p3a  AND    p3a <= '7')  OR
    ('6' <=   p3b  AND    p3b <= '7'))      THEN
   n_nrsum6 = n_nrsum6 + 1;


*Add 1 for bed mobility (p3d) or walking (p3f) training                      ;
IF (('6' <=   p3d  AND    p3d <= '7')  OR
    ('6' <=   p3f  AND    p3f <= '7'))      THEN
   n_nrsum6 = n_nrsum6 + 1;


*Add 1 for splint or brace assistance (p3c)                                  ;
IF ('6' <=   p3c  AND    p3c <= '7')        THEN
   n_nrsum6 = n_nrsum6 + 1;


*Add 1 for transfer training (p3e)                                           ;
IF ('6' <=   p3e  AND    p3e <= '7')        THEN
   n_nrsum6 = n_nrsum6 + 1;


*Add 1 for dressing or grooming training (p3g)                               ;
IF ('6' <=   p3g  AND    p3g <= '7')        THEN
   n_nrsum6 = n_nrsum6 + 1;


*Add 1 for eating or swallowing training (p3h)                               ;
IF ('6' <=   p3h  AND    p3h <= '7')        THEN
   n_nrsum6 = n_nrsum6 + 1;


*Add 1 for amputation/prosthesis care (p3i)                                  ;
IF ('6' <=   p3i  AND    p3i <= '7')        THEN
   n_nrsum6 = n_nrsum6 + 1;


*Add 1 for communication training (p3j)                                      ;
IF ('6' <=   p3j  AND    p3j <= '7')        THEN
   n_nrsum6 = n_nrsum6 + 1;


*Add 1 for any scheduled toileting plan (h3a) or bladder retraining          ;
*   program (h3b)                                                            ;
IF (  h3a = '1' OR   h3b = '1')             THEN
   n_nrsum6 = n_nrsum6 + 1;


*-------------------------------                                             ;
*Determine n_nrsum2.                                                         ;
*   n_nrsum2 is a count of the number of types of nursing rehab activities   ;
*   provided at least 2 days per week.  Note that a scheduled toileting      ;
*   plan or bladder retraining program is included in this count.            ;
n_nrsum2 = 0;

*Add 1 for passive range of motion (p3a) or active range of motion (p3b)     ;
IF (('2' <=   p3a  AND    p3a <= '7')  OR
    ('2' <=   p3b  AND    p3b <= '7'))      THEN
   n_nrsum2 = n_nrsum2 + 1;


*Add 1 for bed mobility (p3d) or walking (p3f) training                      ;
IF (('2' <=   p3d  AND    p3d <= '7')  OR
    ('2' <=   p3f  AND    p3f <= '7'))      THEN
   n_nrsum2 = n_nrsum2 + 1;


*Add 1 for splint or brace assistance (p3c)                                  ;
IF ('2' <=   p3c  AND    p3c <= '7')        THEN
   n_nrsum2 = n_nrsum2 + 1;


*Add 1 for transfer training (p3e)                                           ;
IF ('2' <=   p3e  AND    p3e <= '7')        THEN
   n_nrsum2 = n_nrsum2 + 1;


*Add 1 for dressing or grooming training (p3g)                               ;
IF ('2' <=   p3g  AND    p3g <= '7')        THEN
   n_nrsum2 = n_nrsum2 + 1;


*Add 1 for eating or swallowing training (p3h)                               ;
IF ('2' <=   p3h  AND    p3h <= '7')        THEN
   n_nrsum2 = n_nrsum2 + 1;


*Add 1 for amputation/prosthesis care (p3i)                                  ;
IF ('2' <=   p3i  AND    p3i <= '7')        THEN
   n_nrsum2 = n_nrsum2 + 1;


*Add 1 for communication training (p3j)                                      ;
IF ('2' <=   p3j  AND    p3j <= '7')        THEN
   n_nrsum2 = n_nrsum2 + 1;


*Add 1 for any scheduled toileting plan (h3a) or bladder retraining          ;
*   program (h3b)                                                            ;
IF (  h3a = '1' OR   h3b = '1')           THEN
   n_nrsum2 = n_nrsum2 + 1;


*-------------------------------                                             ;
*Create n_t1c and n_t1d, numeric variables for expected days (t1c) and       ;
*   minutes (t1d) of rehab therapy.                                          ;

*Set value of n_t1c to 0 if t1c is blank or dash filled (value = '--').      ;
IF (  t1c = '  '  OR    t1c = '--')      THEN
   n_t1c = 0;
ELSE
   n_t1c = INPUT(  t1c,2.);


*Set value of n_t1d to 0 if t1dc is blank or dash filled (value = '----').   ;
IF (  t1d = '    '  OR    t1d = '----')  THEN
   n_t1d = 0;
ELSE
   n_t1d = INPUT(  t1d,4.);


*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++;
*Step IV. Test Rehab category qualification.                                 ;
*          Rehab categories are separated by several factors: Total minutes  ;
*          of rehab therapy, number of types of therapy, and number of types ;
*          of nursing rehab activities.                                      ;
*                                                                            ;
*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++;

*-------------------------------                                             ;
*Determine qualification for Ultra High Rehab                                ;
        *-------------------------------                                     ;
        *Resident qualifies for Ultra High Intensity Rehab.                  ;
        *   Qualifications:                                                  ;
        *      (1) 720+ minutes received across all types (n_th_min)         ;
        *                AND                                                 ;
        *      (2) 5+ days received for 1 type of therapy (n_th_ty5)         ;
        *                AND                                                 ;
        *      (3) 3+ days received for a second type of                     ;
        *          therapy (n_th_ty3)                                        ;

IF (       n_th_min >= 720
       AND n_th_ty5 >= 1
       AND n_th_ty3 >= 2   )
  THEN
                     n_reh_u = 1;



*-------------------------------                                             ;
*Determine qualification for Very High Rehab                                 ;
        *-------------------------------                                     ;
        *Resident qualifies for Very High Intensity Rehab.                   ;
        *   Qualifications:                                                  ;
        *      (1) 500+ minutes received across all types (n_th_min)         ;
        *                AND                                                 ;
        *      (2) 5+ days received for 1 type of therapy (n_th_ty5)         ;

IF (       n_th_min >= 500
       AND n_th_ty5 >= 1  )
  THEN
                     n_reh_v = 1;



*-------------------------------                                             ;
*Determine qualification for High Rehab                                      ;
         *-------------------------------                                    ;
         *Resident qualifies for High Intensity Rehab.                       ;
         *      Qualifications:                                              ;
         *         (1) 325+ minutes received across all types (n_th_min)     ;
         *                   AND                                             ;
         *         (2) 5+ days received for 1 type of therapy (n_th_ty5)     ;
         *                                                                   ;
         *   If the resident does not meet these qualifications and          ;
         *   (1) the calculation method selected is Medicare (i.e., the      ;
         *   parameter c_type = 'SMcare') and (2) the reason for             ;
         *   assessment involves a supplemental assessment type of           ;
         *   "5 day assessment" (AA8b = '1') OR "readmission assessment"     ;
         *   (AA8b = '5'), then the resident may qualify for High            ;
         *   Intensity Rehab under the following Special Medicare            ;
         *   Provisions.                                                     ;
         *      Qualifications under Special Medicare Provisions:            ;
         *         (1) Physician has ordered therapies (t1b)                 ;
         *                AND                                                ;
         *         (2) 65+ minutes received across all types (n_th_min)      ;
         *                AND                                                ;
         *         (3) 520+ minutes of expected therapy (t1d)                ;
         *                AND                                                ;
         *         (4) 8+ days of expected therapy (t1c)                     ;

IF (       n_th_min >= 325
       AND n_th_ty5 >= 1   )
  THEN
                     n_reh_h = 1;

ELSE IF ((  aa8b = '1' OR   aa8b = '5') AND c_type = 'SMcare') THEN DO;

   IF (         t1b = '1'
          AND n_th_min >= 65
          AND n_t1d >= 520
          AND (8 <= n_t1c AND n_t1c <= 15))
      THEN
                     n_reh_h = 1;

   END;



*-------------------------------                                             ;
*Determine qualification for Medium Rehab                                    ;
         *-------------------------------                                    ;
         *Resident qualifies for Medium Rehab.                               ;
         *      Qualifications:                                              ;
         *         (1) 150+ minutes received across all types (n_th_min)     ;
         *                AND                                                ;
         *         (2) 5+ days received across all types of                  ;
         *             therapy (n_th_day)                                    ;
         *                                                                   ;
         *   If the resident does not meet these qualifications and          ;
         *   (1) the calculation method selected is Medicare (i.e., the      ;
         *   parameter c_type = 'SMcare') and (2) the reason for             ;
         *   assessment involves a supplemental assessment type of           ;
         *   "5 day assessment" (AA8b = '1') OR "readmission assessment"     ;
         *   (AA8b = '5'), then the resident may qualify for Medium          ;
         *   Intensity Rehab under the following Special Medicare            ;
         *   Provisions.                                                     ;
         *      Qualifications under Special Medicare Provisions:            ;
         *         (1) Physician has ordered therapies (t1b)                 ;
         *                AND                                                ;
         *         (2) 240+ minutes of expected therapy (t1d)                ;
         *                AND                                                ;
         *         (3) 8+ days of expected therapy (t1c)                     ;

IF (n_th_min >= 150 AND n_th_day >= 5)
  THEN
                     n_reh_m = 1;

ELSE IF ((  aa8b = '1' OR   aa8b = '5') AND c_type = 'SMcare') THEN DO;

   IF (  t1b = '1' AND n_t1d >= 240 AND
       (8 <= n_t1c AND n_t1c <= 15))
     THEN
                     n_reh_m = 1;

   END;



*-------------------------------                                             ;
*Determine qualification for Low Rehab                                       ;
         *-------------------------------                                    ;
         *Resident qualifies for Low Intensity Rehab.                        ;
         *      Qualifications:                                              ;
         *         (1) 45+ minutes received across all types (n_th_min)      ;
         *                AND                                                ;
         *         (2) 3+ days received across all types of                  ;
         *             therapy (n_th_day)                                    ;
         *                AND                                                ;
         *         (3) 2+ nursing rehab activities at 6+ days                ;
         *             each (n_nrsum6)                                       ;
         *                                                                   ;
         *   If the resident does not meet these qualifications and          ;
         *   (1) the calculation method selected is Medicare (i.e., the      ;
         *   parameter c_type = 'SMcare') and (2) the reason for             ;
         *   assessment involves a supplemental assessment type of           ;
         *   "5 day assessment" (AA8b = '1') OR "readmission assessment"     ;
         *   (AA8b = '5'), then the resident may qualify for Low             ;
         *   Intensity Rehab under the following Special Medicare            ;
         *   Provisions.                                                     ;
         *      Qualifications under Special Medicare Provisions:            ;
         *         (1) Physician has ordered therapies (t1b)                 ;
         *                AND                                                ;
         *         (2) 75+ minutes of expected therapy (t1d)                 ;
         *                AND                                                ;
         *         (3) 5+ days of expected therapy (t1c)                     ;
         *         (4) 2+ nursing rehab activities at 2+ days                ;
         *             each (n_nrsum2)                                       ;

IF (n_th_min >= 45 AND n_th_day >= 3 AND n_nrsum6 >= 2)
  THEN
                     n_reh_l = 1;

ELSE IF ((  aa8b = '1' OR   aa8b = '5') AND c_type = 'SMcare') THEN DO;

   IF (  t1b = '1' AND n_t1d >= 75  AND
       (5 <= n_t1c AND n_t1c <= 15) AND
       n_nrsum2 >= 2)
     THEN
                     n_reh_l = 1;

   END;



*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++          ;
*Step V.  Test Extensive Care qualification.                                 ;
*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++          ;
                                                                             ;
*-------------------------------                                             ;
*Determine qualification for Extensive Care.                                 ;
                                                                             ;
*Check for required Extensive Care clinical indicators.                      ;
   *-------------------------------                                          ;
   *Resident qualifies for Extensive Care category on the basis of clinical  ;
   *indicators.                                                              ;
   *   Qualifications:                                                       ;
   *      Parenteral/IV feedings (k5a) OR IV medication (p1ac) OR            ;
   *      suctioning (p1ai) OR tracheostomy care (p1aj) OR                   ;
   *      ventilator or respirator (p1al).                                   ;

   *-------------------------------                                          ;

IF (  k5a  = '1'  OR
      p1ac = '1'  OR
      p1ai = '1'  OR
      p1aj = '1'  OR
      p1al = '1')
  THEN
   n_ext = 1;



*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++          ;
*Step VI.  Test Special Care qualification.                                  ;
*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++          ;

*-------------------------------                                             ;
*Code count of all levels of ulcer (n_ulcer) for Special Care                ;
*   qualification                                                            ;
n_ulcer = 0;
IF ('1' <=   m1a AND   m1a <= '9')      THEN
   n_ulcer = n_ulcer + INPUT(  m1a,1.);

IF ('1' <=   m1b AND   m1b <= '9')      THEN
   n_ulcer = n_ulcer + INPUT(  m1b,1.);

IF ('1' <=   m1c AND   m1c <= '9')      THEN
   n_ulcer = n_ulcer + INPUT(  m1c,1.);

IF ('1' <=   m1d AND   m1d <= '9')      THEN
   n_ulcer = n_ulcer + INPUT(  m1d,1.);


*-------------------------------                                             ;
*Code count of selected skin care treatments for Special Care                ;
*   qualification                                                            ;
n_sk_tr = 0;
IF   m5a = '1'  OR    m5b = '1'  THEN
   n_sk_tr = n_sk_tr + 1;

IF   m5c = '1'                   THEN
   n_sk_tr = n_sk_tr + 1;

IF   m5d = '1'                   THEN
   n_sk_tr = n_sk_tr + 1;

IF   m5e = '1'                   THEN
   n_sk_tr = n_sk_tr + 1;

IF   m5g = '1'                   THEN
n_sk_tr = n_sk_tr + 1;

IF   m5h = '1'                   THEN
   n_sk_tr = n_sk_tr + 1;


*-------------------------------                                             ;
*Check for required Special Care clinical indicators                         ;
         *-------------------------------                                    ;
         *Resident qualifies for Special Care category on the basis of       ;
         *clinical indicators.                                               ;
         *   Qualifications (any one sufficient):                            ;
         *      1. Two or more ulcers of any type (n_ulcer) OR stage 3       ;
         *         or 4 pressure ulcer (m2a)                                 ;
         *            AND                                                    ;
         *         two or more selected skin care treatments (n_sk_tr).      ;
         *      2. Feeding tube (k5b) WITH parenteral/enteral intake         ;
         *         (n_intake) AND aphasia (i1r).                             ;
         *      3. Surgical wounds (m4g) OR open lesions other than          ;
         *         ulcers, rashes, cuts (m4c)                                ;
         *            AND                                                    ;
         *         surgical wound care (m5f) OR application of               ;
         *         dressings (m5g) OR application of ointments (m5h).        ;
         *      4. Respiratory therapy for 7 days (p1bda).                   ;
         *      5. Cerebral palsy (i1s) AND ADL score of 10 or more          ;
         *         (n_adlsum).                                               ;
         *      6. Fever (j1h)                                               ;
         *            AND                                                    ;
         *         vomiting (j1o) OR weight loss (k3a) OR tube feeding       ;
         *         (k5b) WITH high parenteral/enteral intake (n_intake)      ;
         *         OR pneumonia (i2e) OR dehydrated (j1c).                   ;
         *      7. Multiple sclerosis (i1w) AND ADL score of 10 or more      ;
         *         (n_adlsum).                                               ;
         *      8. Quadriplegia (i1z) AND ADL score of 10 or more            ;
         *         (n_adlsum).                                               ;
         *      9. Radiation therapy (p1ah).                                 ;

IF (      ((n_ulcer >= 2  OR    m2a = '3'  OR    m2a = '4')
              AND
           n_sk_tr >= 2)
      OR  ((  k5b = '1'  AND  n_intake = 1)  AND    i1r='1'  )
      OR  ((  m4g = '1'  OR    m4c = '1')
              AND
           (  m5f = '1'  OR    m5g = '1'  OR    m5h='1'))
      OR     p1bda = '7'
      OR  (  i1s = '1'  AND  n_adlsum >= 10)
      OR  (  j1h = '1'
              AND
           (  j1o = '1'
                  OR    k3a = '1'
                  OR  (  k5b= '1'  AND  n_intake = 1)
                  OR    i2e='1'
                  OR    j1c='1'))
      OR  (  i1w  = '1'  AND  n_adlsum >= 10)
      OR  (  i1z  = '1'  AND  n_adlsum >= 10)
      OR    p1ah = '1')
  THEN
         n_spec = 1;



*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++          ;
*Step VII. Test Clinically Complex qualification.                            ;
*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++          ;

*-------------------------------                                             ;
*Calculate the number of periods the resident is not awake (n_n_awak).       ;
*   This variable is used in determining whether the resident is comatose    ;
*   or not.  This calculation influences qualification for both Clinically   ;
*   Complex and Cognitive Impairment.  This count (n_n_awak) is based on     ;
*   items n1a, n1b, and n1c.  For RUG-III classification, it is assumed      ;
*   that the resident is not awake, only if the response to an item is a     ;
*   0 (zero).  If the response to an item is '-' (unknown), then it is       ;
*   treated as if the resident were awake for that period.                   ;
n_n_awak = 0;
IF   n1a = '0'   THEN
   n_n_awak = n_n_awak + 1;

IF   n1b = '0'   THEN
   n_n_awak = n_n_awak + 1;

IF   n1c = '0'   THEN
   n_n_awak = n_n_awak + 1;


*-------------------------------                                             ;
*Calculate n_coma indicating whether the resident is comatose with qualifiers;
*      n_coma = 1 if resident is comatose (b1 = 1) and not awake all three   ;
*                 periods (n_n_awak = 3) and ADL dependent (g1aa, g1ba, g1ha,;
*                 and g1ia all have values of '4' or '8').                   ;
*             = 0 otherwise.                                                 ;

n_coma = 0;

IF (           b1 = '1'
        AND  n_n_awak  = 3
        AND  (  g1aa = '4'  OR    g1aa = '8')
        AND  (  g1ba = '4'  OR    g1ba = '8')
        AND  (  g1ha = '4'  OR    g1ha = '8')
        AND  (  g1ia = '4'  OR    g1ia = '8') )
  THEN
           n_coma = 1;



*-------------------------------                                             ;
*Make numeric versions of p7 and p8 for ease of coding, setting value to 0   ;
*   if item dash filled (value of '--').                                     ;
n_p7 = 0;
IF   p7 NE '--'             THEN
      n_p7 = INPUT(  p7,2.);

n_p8 = 0;
IF   p8 NE '--'             THEN
      n_p8 =INPUT(  p8,2.);


*-------------------------------                                             ;
*Check for Clinically Complex qualification.                                 ;
         *Resident qualifies for Clinically Complex category on the basis of ;
         *clinical indicators.                                               ;
         *-------------------------------                                    ;
         *   Qualifications (any one sufficient):                            ;
         *      1. Feeding tube (k5b) WITH high parenteral/enteral           ;
         *         intake (n_intake).                                        ;
         *      2. Comatose (b1) AND not awake (n_n_awak) AND                ;
         *         ADL dependent (g1aa, g1ba, g1ha, g1ia).                   ;
         *      3. Septicemia (i2g).                                         ;
         *      4. Burns--second or third degree (m4b).                      ;
         *      5. Dehydration (j1c).                                        ;
         *      6. Hemiplegia/hemiparesis (i1v) and ADL score of             ;
         *         10 or more (n_adlsum).                                    ;
         *      7. Internal bleeding (j1j).                                  ;
         *      8. Pneumonia (i2e).                                          ;
         *      9. End stage disease (j5c).-removed from 5.12                ;
         *     10. Chemotherapy (p1aa).                                      ;
         *     11. Dialysis (p1ab).                                          ;
         *     12. Physician order changes (p8) on 4 or more days            ;
         *         AND physician visits (p7) on 1 or more days.              ;
         *     13. Physician order changes (p8) on 2 or more days            ;
         *         AND physician visits (p7) on 2 or more days.              ;
         *     14. Diabetes (i1a) AND injections (o3) on 7 days              ;
         *         AND physician order changes (p8) on 2 or more             ;
         *         days.                                                     ;
         *     15. Transfusions (p1ak).                                      ;
         *     16. Oxygen therapy (p1ag).                                    ;
         *     17. Infection on foot (m6b) OR open lesion on foot (m6c)      ;
         *            AND                                                    ;
         *         application of dressings to foot (m6f).                   ;

IF (      (  k5b  = '1'  AND  n_intake = 1)
      OR  n_coma = 1
      OR    i2g = '1'
      OR    m4b = '1'
      OR    j1c = '1'
      OR  (  i1v = '1'  AND  n_adlsum >= 10)
      OR    j1j = '1'
      OR    i2e = '1'
  /*    OR    j5c = '1'  */
      OR    p1aa = '1'
      OR    p1ab = '1'
      OR  ((4 <= n_p8  AND  n_p8 <= 14)  AND
           (1 <= n_p7  AND  n_p7 <= 14))
      OR  ((2 <= n_p8  AND  n_p8 <= 14)  AND
           (2 <= n_p7  AND  n_p7 <= 14))
      OR  (  i1a= '1'  AND    o3 = '7'
              AND  (2 <= n_p8  AND  n_p8 <= 14))
      OR    p1ak = '1'
      OR    p1ag = '1'
      OR  ((  m6b = '1'  OR    m6c = '1')
              AND  (  m6f = '1' ))  )
  THEN
         n_clin = 1;



*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++;
*Step VIII.  Determine depression variable (n_depres) needed                 ;
*               for splitting the Clinically Complex Category.               ;
*            n_depres is a depression flag indicating presence of            ;
*               depression (value 1) or absence of depression (value 0).     ;
*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++;

*-------------------------------                                             ;
*Determine count of depression indicators (n_mood)                           ;
n_mood = 0;
IF   e1a = '1'  OR    e1a = '2'  THEN
   n_mood = n_mood +1;

IF   e1b = '1'  OR    e1b = '2'  THEN
   n_mood = n_mood +1;

IF   e1c = '1'  OR    e1c = '2'  THEN
   n_mood = n_mood +1;

IF   e1d = '1'  OR    e1d = '2'  THEN
   n_mood = n_mood +1;

IF   e1e = '1'  OR    e1e = '2'  THEN
   n_mood = n_mood +1;

IF   e1f = '1'  OR    e1f = '2'  THEN
   n_mood = n_mood +1;

IF   e1g = '1'  OR    e1g = '2'  THEN
   n_mood = n_mood +1;

IF   e1h = '1'  OR    e1h = '2'  THEN
   n_mood = n_mood +1;

IF   e1i = '1'  OR    e1i = '2'  THEN
   n_mood = n_mood +1;

IF   e1j = '1'  OR    e1j = '2'  THEN
   n_mood = n_mood +1;

IF   e1k = '1'  OR    e1k = '2'  THEN
   n_mood = n_mood +1;

IF   e1l = '1'  OR    e1l = '2'  THEN
   n_mood = n_mood +1;

IF   e1m = '1'  OR    e1m = '2'  THEN
   n_mood = n_mood +1;

IF   e1n = '1'  OR    e1n = '2'  THEN
   n_mood = n_mood +1;

IF   e1o = '1'  OR    e1o = '2'  THEN
   n_mood = n_mood +1;

IF   e1p = '1'  OR    e1p = '2'  THEN
   n_mood = n_mood +1;


*-------------------------------                                             ;
*Set depression flag (n_depres).                                             ;
IF n_mood >= 3   THEN
   n_depres = 1;
ELSE
   n_depres = 0;


*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++                  ;
*Step IX. Test Cognitive Impairment qualification.                           ;
*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++                  ;
*                                                                            ;
*Note:  RUG-III Cognitive Impairment qualification is based on               ;
*       the Cognitive Performance Scale.                                     ;
*                                                                            ;
*   Details concerning this scale are available in:                          ;
*                                                                            ;
*       Morris JN, Fries BE, Morris JN, Fries BE, Mehr DR, Hawes C,          ;
*       Phillips C, Mor V, and Lipsitz LA.  "MDS Cognitive Performance       ;
*       Scale" J. Gerontology: Medical Sciences 49(4):M174-M182 (July)       ;
*       1994.                                                                ;
*                                                                            ;
*   For use in RUG-III classification, the Cognitive Performance             ;
*   Scale logic has been modified to use the same qualifiers for             ;
*   a comatose condition as used for Clinically Complex qualification.       ;
*                                                                            ;
*   Note that a previously calculated variable, n_coma, is used in the       ;
*   Cognitive Performance Scale.                                             ;
*      n_coma = 1 if resident is comatose (b1 = 1) and not awake             ;
*                 (n_n_awak = 3) and ADL dependent (g1aa, g1ba, g1ha, and    ;
*                 g1ia all have values of '4' or '8').                       ;
*             = 0 otherwise.                                                 ;
                                                                             ;
*-------------------------------                                             ;
*Calculate n_cog1 and n_cog2 variables used in Cognitive Performance Scale.  ;
*   n_cog1 is a count of non-independence on three items (b2a, b4, and       ;
*          c4).                                                              ;
*   n_cog2 is a count of moderate to severe impairment on two items          ;
*          (b4 and c4).                                                      ;
*                                                                            ;
*   Both n_cog1 and n_cog2 have default values of -1 (missing) and are       ;
*   only calculated if item b2a is in the range 0 to 1, item b4 is in        ;
*   the range 0 to 3, and item c4 is in the range 0 to 3.                    ;

n_cog1 = -1;
n_cog2 = -1;

IF ((  b2a >= '0'  AND    b2a <= '1')  AND
    (  b4  >= '0'  AND    b4  <= '3')  AND
    (  c4  >= '0'  AND    c4  <= '3') )
  THEN DO;
       n_cog1 = 0;
       IF (  b2a = '1')                                 THEN
          n_cog1 = n_cog1 + 1;

       IF (  b4 = '1'  OR    b4 = '2')                  THEN
          n_cog1 = n_cog1 + 1;

       IF (  c4 = '1'  OR    c4 = '2'  OR    c4 = '3')  THEN
          n_cog1 = n_cog1 + 1;


       n_cog2 = 0;
       IF (  b4 = '2')                                  THEN
          n_cog2 = n_cog2 + 1;

       IF (  c4 = '2'  OR    c4 = '3')                  THEN
          n_cog2 = n_cog2 + 1;

       END;


*-------------------------------                                             ;
*Calculate n_cps--Cognitive Performance Scale .                              ;
*                                                                            ;
*   Cognitive Performance Scale Codes:                                       ;
*          0 = intact                                                        ;
*          1 = borderline intact                                             ;
*          2 = mild impairment                                               ;
*          3 = moderate impairment                                           ;
*          4 = moderately severe impairment                                  ;
*          5 = severe impairment                                             ;
*          6 = very severe impairment                                        ;

*Set n_cps to a default of 0 and calculate                                   ;
n_cps = 0;

IF     (n_coma = 1  AND
         NOT  (  b4 = '0'  OR    b4 = '1'  OR    b4 = '2'))      THEN
                 n_cps = 6;
ELSE IF   b4= '3'                                                THEN DO;
       IF     (  g1ha = '4'  OR    g1ha = '8')                   THEN
                 n_cps = 6;
       ELSE IF (  g1ha = '-'  OR    g1ha = '0'  OR    g1ha = '1'
                OR    g1ha ='2'  OR    g1ha ='3')                THEN
                 n_cps = 5;
       END;
ELSE IF (n_cog1 = 2  OR  n_cog1 = 3)                             THEN DO;
       IF     n_cog2 = 2                                         THEN
                 n_cps = 4;
       ELSE IF n_cog2 = 1                                        THEN
                 n_cps = 3;
       ELSE IF n_cog2 = 0                                        THEN
                 n_cps = 2;
       END;
ELSE IF n_cog1 = 1                                               THEN
                 n_cps = 1;


*-------------------------------                                             ;
*Determine Cognitive Impairment qualification.                               ;
*   Qualification if Cognitive Performance Scale is 3 or more.               ;

IF n_cps >= 3
  THEN
   n_impair = 1;



*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++                  ;
*Step X. Test Behavior Problems qualification.                               ;
*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++                  ;

*-------------------------------                                             ;
*Check for Behavior Problems qualification.                                  ;
         *-------------------------------                                    ;
         *Behavior Problems Qualifications (any one sufficient):             ;
         *      1. Wandering occurred on 4 or more days (e4aa).              ;
         *      2. Verbally abusive behavior occurred on 4 or more           ;
         *         days (e4ba).                                              ;
         *      3. Physically abusive behavior occurred on 4 or              ;
         *         more days (e4ca).                                         ;
         *      4. Socially inappropriate/disruptive behavior                ;
         *         occurred on 4 or more days (e4da).                        ;
         *      5. Resident resisted care on 4 or more days (e4ea).          ;
         *      6. Hallucinations (j1i).                                     ;
         *      7. Delusions (j1e).                                          ;

IF (     (  e4aa = '2'  OR    e4aa =  '3')
     OR  (  e4ba = '2'  OR    e4ba =  '3')
     OR  (  e4ca = '2'  OR    e4ca =  '3')
     OR  (  e4da = '2'  OR    e4da =  '3')
     OR  (  e4ea = '2'  OR    e4ea =  '3')
     OR  (  j1i = '1')
     OR  (  j1e = '1'))
   THEN
         n_behav = 1;


*++++++++++++++++++++++++++++++++++++++++                                    ;
*Step XI. Compute ancillary domain variables                                 ;
*         to use in ancillary end splits                                     ;
*++++++++++++++++++++++++++++++++++++++++                                    ;

*----------------------------------------------------------------------      ;
*Domain  1:  Stage 4 Ulcer                                                   ;
*Definition:  1 or more stage 4 ulcers                                       ;

n_ulc4st = 0;
If (M1d >= '1' And M1d <= '9')
   Then 
      n_ulc4st = 1;

*----------------------------------------------------------------------      ;
*Domain  2:  Skin Care                                                       ;
*Definition 1: ulcer care received                                           ;

n_skcar1 = 0;
If M5e = '1' 
   Then
      n_skcar1 = 1;

*----------------------------------------------------------------------      ;
*Domain  2:  Skin Care                                                       ;
*Definition 2: ulcer care received with stage 3 or higher pressure ulcers    ;

n_skcar2 = 0;
If (M5e = '1') And (M2a = '3' Or M2a = '4') 
   Then
      n_skcar2 = 1;

*----------------------------------------------------------------------      ;
*Domain  2:  Skin Care                                                       ;
*Definition 3: EITHER (ulcer care received with stage 3 or higher pressure   ;
*              ulcers present) OR (surgical wound care received              ;
*              with surgical wounds present)                                 ;

n_skcar3 = 0;
If (M5e = '1' And (M2a = '3' Or M2a = '4'))
   Or
   (M5f = '1' And M4g = '1')   
      Then
         n_skcar3 = 1;

*----------------------------------------------------------------------      ;
*Domain  2:  Skin Care                                                       ;
*Definition 4: EITHER ulcer care received OR surgical wound care received    ;

n_skcar4 = 0;
If (M5e = '1' Or M5f = '1') 
   Then
      n_skcar4 = 1;

*----------------------------------------------------------------------      ;
*Domain  2:  Skin Care                                                       ;
*Definition 5: EITHER (ulcer care received with stage 1 or higher pressure   ;
*              ulcers present) OR (surgical wound care received              ;
*              with surgical wounds present)                                 ;

n_skcar5 = 0;
If (M5e = '1' And (M2a >= '1' And M2a <= '4'))
   Or
   (M5f = '1' And M4g = '1')   
      Then
         n_skcar5 = 1;

*----------------------------------------------------------------------      ;
*Domain  3:  IV Medications                                                  ;
*Definition:  IV medications received                                        ;

n_ivmed = 0;
If P1ac = '1' 
   Then 
      n_ivmed = 1;

*----------------------------------------------------------------------      ;
*Domain  4:  Respiratory Infection                                           ;
*Definition:  Respiratory infection present                                  ;

n_resp = 0;
If I2f = '1' 
   Then 
      n_resp = 1;

*----------------------------------------------------------------------      ;
*Domain  5: Tracheostomy Care                                                ;
*Definition: Tracheostomy care present                                       ;

n_trach = 0;
If P1aj = '1' 
   Then 
      n_trach = 1;

*----------------------------------------------------------------------      ;
*Domain  6: Suctioning                                                       ;
*Definition: Suctioning received                                             ;

n_suct = 0;
If P1ai = '1' 
   Then 
      n_suct = 1;

*----------------------------------------------------------------------      ;
*Domain  7: Pneumonia                                                        ;
*Definition: Pneumonia present                                               ;

n_pneum = 0;
If I2e = '1' 
   Then 
      n_pneum = 1;

*----------------------------------------------------------------------      ;
*Domain  8: Parenteral/IV                                                    ;
*Definition: BOTH (pareneteral/IV nutrition used) AND (parenteral            ;
*            or enteral intake is 76% or more of total calories)             ;

n_par_iv = 0;
If (K5a = '1') And (K6a = '4') 
   Then 
      n_par_iv = 1;

*----------------------------------------------------------------------      ;
*Domain  9: Feeding Tube                                                     ;
*Definition: BOTH (feeding tube used) AND (parenteral or enteral             ;
*            intake is 76% or more of total calories)                        ;

n_tube = 0;
If (K5b = '1') And (K6a = '4') 
   Then 
      n_tube = 1;

*----------------------------------------------------------------------      ;
*Domain 10: Oxygen Therapy                                                   ;
*NOTE I1d NOT USED IN THIS VERSION.                                          ;
*Definition: Oxygen therapy received AND any of the following                ;
*            combinations of conditions:                                     ;
*              (1) (pneumonia) AND (fever OR shortness of breath)            ;
*                        OR                                                  ;
*              (2) (respiratory infection) AND (fever OR shortness of breath);
*                        OR                                                  ;
*              (3) (emphysema/COPD) AND (shortness of breath)                ;
*                        OR                                                  ;
*              (4) (congestive heart failure/CHF) AND (shortness of breath)  ;
*                        OR                                                  ;
*  NOT USED>>  (5) (arterioslerotic heart disease/CAD) AND (shortness of     ;
*                   breath)                                                  ;

n_oxygen = 0;
If (P1ag = '1') 
   And (
          ((I2e = '1') And (J1h = '1' Or J1L = '1')) 
          Or
          ((I2f = '1') And (J1h = '1' Or J1L = '1'))
          OR
          ((I1ii = '1') And (J1L = '1'))
          OR
          ((I1f = '1') And (J1L = '1')))
              Then
                 n_oxygen = 1;

*----------------------------------------------------------------------      ;
*Domain 11:  Dressings                                                       ;
*Definition 1: foot dressing AND any one of the following conditions:        ;
*                (1) ulcers at stage 1 or higher                             ;
*                             OR                                             ;
*                (2) abrasions/bruises                                       ;
*                             OR                                             ;
*                (3) burns                                                   ;
*                             OR                                             ;
*                (4) open lesions other than ulcers                          ;
*                             OR                                             ;
*                (5) rashes                                                  ;
*                             OR                                             ;
*                (6) skin desensitized                                       ;
*                             OR                                             ;
*                (7) skin tears or cuts                                      ;
*                             OR                                             ;
*                (8) surgical wounds                                         ;

n_dress1 = 0;
If (M6f = '1') 
   And (
           (M1a >= '1' And M1a <= '4') Or (M1b >= '1' And M1b <= '4') Or 
           (M1c >= '1' And M1c <= '4') Or (M1d >= '1' And M1d <= '4') Or 
           (M4a = '1')  Or (M4b = '1')  Or (M4c = '1')  Or (M4d >= '1') Or 
           (M4e = '1')  Or (M4f = '1')  Or (M4g = '1')   )		
              Then
                 n_dress1 = 1;

*----------------------------------------------------------------------      ;
*Domain 11:  Dressings                                                       ;
*Definition 2: (foot dressing OR other dressing) AND any one of              ;
*                the following conditions:                                   ;
*                  (1) ulcers at stage 1 or higher                           ;
*                               OR                                           ;
*                  (2) abrasions/bruises                                     ;
*                               OR                                           ;
*                  (3) open lesions other than ulcers                        ;
*                               OR                                           ;
*                  (4) rashes                                                ;
*                               OR                                           ;
*                  (5) skin desensitized                                     ;
*                               OR                                           ;
*                  (6) skin tears or cuts                                    ;
*                               OR                                           ;
*                  (7) surgical wounds                                       ;

n_dress2 = 0;
If (M6f = '1' Or M5g = '1') 
   And (
          (M1a >= '1' And M1a <= '4') Or (M1b >= '1' And M1b <= '4') Or 
          (M1c >= '1' And M1c <= '4') Or (M1d >= '1' And M1d <= '4') Or 
          (M4a = '1')  Or (M4c = '1')  Or (M4d = '1')  Or (M4e = '1')  Or 
          (M4f = '1')  Or (M4g = '1')    )		
             Then
                n_dress2 = 1;

*----------------------------------------------------------------------      ;
*Domain 11:  Dressings                                                       ;
*Definition 3: (foot dressing OR other dressing) AND any one of              ;
*              the following conditions:                                     ;
*                 (1) ulcers at stage 1 or higher                            ;
*                              OR                                            ;
*                 (2) abrasions/bruises                                      ;
*                              OR                                            ;
*                 (3) open lesions other than ulcers                         ;
*                              OR                                            ;
*                 (4) rashes                                                 ;
*                              OR                                            ;
*                 (5) skin desensitized                                      ;
*                              OR                                            ;
*                 (6) skin tears or cuts                                     ;
*                              OR                                            ;
*                 (7) surgical wounds                                        ;
*                              Or                                            ;
*                 (8) foot lesions                                           ;

n_dress3 = 0;
If (M6f = '1' Or M5g = '1') 
   And (
          (M1a >= '1' And M1a <= '4') Or (M1b >= '1' And M1b <= '4') Or 
          (M1c >= '1' And M1c <= '4') Or (M1d >= '1' And M1d <= '4') Or 
          (M4a = '1')  Or (M4c = '1')  Or (M4d = '1')  Or (M4e = '1')  Or 
          (M4f = '1')  Or (M4g = '1')  Or (M6c = '1')	 )
             Then
                n_dress3 = 1;

*----------------------------------------------------------------------      ;
*Domain 11:  Dressings                                                       ;
*Definition 4: (foot dressing OR other dressing) AND any one of              ;
*               the following conditions:                                    ;
*                  (1) ulcers at stage 1 or higher                           ;
*                               OR                                           ;
*                  (2) abrasions/bruises                                     ;
*                               OR                                           ;
*                  (3) burns                                                 ;
*                               OR                                           ;
*                  (4) open lesions other than ulcers                        ;
*                               OR                                           ;
*                  (5) rashes                                                ;
*                               OR                                           ;
*                  (6) skin desensitized                                     ;
*                               OR                                           ;
*                  (7) skin tears or cuts                                    ;
*                               OR                                           ;
*                  (8) surgical wounds                                       ;
*                               Or                                           ;
*                  (9) foot lesions                                          ;

n_dress4 = 0;
If (M6f = '1' Or M5g = '1') 
   And (
          (M1a >= '1' And M1a <= '4') Or (M1b >= '1' And M1b <= '4') Or 
          (M1c >= '1' And M1c <= '4') Or (M1d >= '1' And M1d <= '4') Or 
          (M4a = '1')  Or (M4b = '1')  Or (M4c = '1')  Or (M4d = '1')  Or 
          (M4e = '1')  Or (M4f = '1')  Or (M4g = '1')  Or (M6c = '1')   ) 
             Then
                n_dress4 = 1;

*++++++++++++++++++++++++++++++++++++++++                                    ;
*Step XII. Classify into RUG-III Groups                                      ;
*++++++++++++++++++++++++++++++++++++++++                                    ;

*-------------------------------                                             ;
*Classify into Extensive & Rehab Groups*****                                 ;
* All final splits based on ADL sum (n_adlsum).                              ;

*-------------------------------                                             ;
*Classify into Extensive & Ultra High Intensity Rehab groups*****            ;
*                                                                            ;
*   Classify if both Extensive and Ultra High rehab indicators present.      ;
*                                                                            ;
*   Determine final splits for Extensive & Ultra High Intensity Rehab resids.;
*   on the basis of ADL sum.                                                 ;
IF n_reh_u = 1 AND (n_ext = 1  AND  n_adlsum >=7) THEN DO;

   IF     (16 <= n_adlsum  AND  n_adlsum <= 18)   THEN DO;
             c_rug_hr= 'XUC';        n_rug_hr=1;
             n_cmi_hi = n_cmi(1); c_rug_mx=1;          END;
   ELSE IF ( 9 <= n_adlsum  AND  n_adlsum <= 15)  THEN DO;
             c_rug_hr= 'XUB';        n_rug_hr=2;
             n_cmi_hi = n_cmi(2); c_rug_mx=2;          END;
   ELSE IF ( 4 <= n_adlsum  AND  n_adlsum <=  8)  THEN DO;
             c_rug_hr= 'XUA';        n_rug_hr=3;
             n_cmi_hi = n_cmi(3); c_rug_mx=3;          END;

END;


*-------------------------------                                             ;
*Classify into Extensive & Very High Intensity Rehab groups*****             ;
*                                                                            ;
*   Classify if both Extensive and Very High rehab indicators present and    ;
*      (1) a previous hierarchical classification has not been made          ;
*          (indicated by n_cmi_hi being at a default negative value)         ;
*   or (2) yields a higher rate for index maximization.                      ;
*                                                                            ;
*                                                                            ;
*   Determine final splits for Extensive & Very High Intensity Rehab resids. ;
*   on the basis of ADL sum.  Accept classification into a group if CMI      ;
*   for that group is higher than previous high CMI.                         ;
                                                                             ;
IF (n_reh_v = 1) AND (n_ext = 1  AND  n_adlsum >=7)  THEN DO;




   IF     (16 <= n_adlsum  AND  n_adlsum <= 18)   THEN DO;
             IF n_cmi(4) > n_cmi_hi               THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'XVC'; n_rug_hr=4;  END;
                n_cmi_hi = n_cmi(4);                   c_rug_mx=4;       END;
   END;
   ELSE IF ( 9 <= n_adlsum  AND  n_adlsum <= 15)  THEN DO;
             IF n_cmi(5) > n_cmi_hi               THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'XVB'; n_rug_hr=5;  END;
                n_cmi_hi = n_cmi(5);                   c_rug_mx=5;       END;
   END;
   ELSE IF ( 4 <= n_adlsum  AND  n_adlsum <=  8)  THEN DO;
             IF n_cmi(6) > n_cmi_hi               THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'XVA'; n_rug_hr=6;  END;
                n_cmi_hi = n_cmi(6);                   c_rug_mx=6;       END;
   END;

END;


*-------------------------------                                             ;
*Classify into Extensive & High Intensity Rehab groups*****                  ;
*                                                                            ;
*   Classify if both Extensive and High Rehab indicators present and         ;
*      (1) a previous hierarchical classification has not been made          ;
*          (indicated by n_cmi_hi being at a default negative value)         ;
*   or (2) yields a higher rate for index maximization.                      ;
*                                                                            ;
*                                                                            ;
*   Determine final splits for Extensive & High Intensity Rehab residents    ;
*   on the basis of ADL sum.  Accept classification into a group if CMI      ;
*   for that group is higher than previous high CMI.                         ;

IF (n_reh_h = 1) AND (n_ext = 1  AND  n_adlsum >=7)  THEN DO;




   IF     (13 <= n_adlsum  AND  n_adlsum <= 18)   THEN DO;
             IF n_cmi(7) > n_cmi_hi               THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'XHC'; n_rug_hr=7;  END;
                n_cmi_hi = n_cmi(7);                   c_rug_mx=7;       END;
   END;
   ELSE IF ( 8 <= n_adlsum  AND  n_adlsum <= 12)  THEN DO;
             IF n_cmi(8) > n_cmi_hi               THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'XHB'; n_rug_hr=8;  END;
                n_cmi_hi = n_cmi(8);                   c_rug_mx=8;       END;
   END;
   ELSE IF ( 4 <= n_adlsum  AND  n_adlsum <=  7)  THEN DO;
             IF n_cmi(9) > n_cmi_hi               THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'XHA'; n_rug_hr=9;  END;
                n_cmi_hi = n_cmi(9);                   c_rug_mx=9;       END;
   END;

END;


*-------------------------------                                             ;
*Classify into Extensive & Medium Intensity Rehab groups*****                ;
*                                                                            ;
*   Classify if both Extensive and Medium Rehab indicators present and       ;
*      (1) a previous hierarchical classification has not been made          ;
*          (indicated by n_cmi_hi being at a default negative value)         ;
*   or (2) yields a higher rate for index maximization.                      ;
*                                                                            ;
*                                                                            ;
*   Determine final splits for Extensive & Medium Intensity Rehab residents  ;
*   on the basis of ADL sum.  Accept classification into a group if CMI      ;
*   for that group is higher than previous high CMI.                         ;

IF (n_reh_m = 1) AND (n_ext = 1  AND  n_adlsum >=7)  THEN DO;




   IF     (15 <= n_adlsum  AND  n_adlsum <= 18)   THEN DO;
             IF n_cmi(10) > n_cmi_hi              THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'XMC'; n_rug_hr=10; END;
                n_cmi_hi = n_cmi(10);                  c_rug_mx=10;      END;
   END;
   ELSE IF ( 8 <= n_adlsum  AND  n_adlsum <= 14)  THEN DO;
             IF n_cmi(11) > n_cmi_hi              THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'XMB'; n_rug_hr=11; END;
                n_cmi_hi = n_cmi(11);                  c_rug_mx=11;      END;
   END;
   ELSE IF ( 4 <= n_adlsum  AND  n_adlsum <=  7)  THEN DO;
             IF n_cmi(12) > n_cmi_hi              THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'XMA'; n_rug_hr=12; END;
                n_cmi_hi = n_cmi(12);                  c_rug_mx=12;      END;
   END;

END;


*-------------------------------                                             ;
*Classify into Extensive & Low Intensity Rehab groups*****                   ;
*                                                                            ;
*   Classify if both Extensive and Low Rehab indicators present and          ;
*      (1) a previous hierarchical classification has not been made          ;
*          (indicated by n_cmi_hi being at a default negative value)         ;
*   or (2) yields a higher rate for index maximization.                      ;
*                                                                            ;
*                                                                            ;
*   Determine final splits for Extensive & Low Intensity Rehab residents     ;
*   on the basis of ADL sum.  Accept classification into a group if CMI      ;
*   for that group is higher than previous high CMI.                         ;

IF (n_reh_l = 1) AND (n_ext = 1  AND  n_adlsum >=7)  THEN DO;




   IF     (14 <= n_adlsum  AND  n_adlsum <= 18)   THEN DO;
             IF n_cmi(13) > n_cmi_hi              THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'XLB'; n_rug_hr=13;  END;
                n_cmi_hi = n_cmi(13) ;                 c_rug_mx=13;       END;
   END;
   ELSE IF ( 4 <= n_adlsum  AND  n_adlsum <= 13)  THEN DO;
             IF n_cmi(14) > n_cmi_hi              THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'XLA'; n_rug_hr=14; END;
                n_cmi_hi = n_cmi(14);                  c_rug_mx=14;      END;
   END;

END;



*-------------------------------                                             ;
*Classify into Rehab Groups*****                                             ;
* All final splits based on ADL sum (n_adlsum).                              ;

*-------------------------------                                             ;
*Classify into Ultra High Intensity Rehab groups*****                        ;
*                                                                            ;
*   Classify if Ultra High rehab indicators present.                         ;
*                                                                            ;
*   Determine final splits for Ultra High Intensity Rehab residents          ;
*   on the basis of ADL sum.                                                 ;
IF n_reh_u = 1                                    THEN DO;

   IF     (16 <= n_adlsum  AND  n_adlsum <= 18)   THEN DO;
             IF n_cmi(15) > n_cmi_hi              THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'RUC'; n_rug_hr=15; END;
                n_cmi_hi = n_cmi(15);                  c_rug_mx=15;      END;
   END;
   ELSE IF ( 9 <= n_adlsum  AND  n_adlsum <= 15)  THEN DO;
             IF n_cmi(16) > n_cmi_hi              THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'RUB'; n_rug_hr=16; END;
                n_cmi_hi = n_cmi(16);                  c_rug_mx=16;      END;
   END;
   ELSE IF ( 4 <= n_adlsum  AND  n_adlsum <=  8)  THEN DO;
             IF n_cmi(17) > n_cmi_hi              THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'RUA'; n_rug_hr=17; END;
                n_cmi_hi = n_cmi(17);                  c_rug_mx=17;      END;
   END;

END;


*-------------------------------                                             ;
*Classify into Very High Intensity Rehab groups*****                         ;
*                                                                            ;
*   Classify if Very High rehab indicators present and                       ;
*      (1) a previous hierarchical classification has not been made          ;
*          (indicated by n_cmi_hi being at a default negative value)         ;
*   or (2) yields a higher rate for index maximization.                      ;
*                                                                            ;
*                                                                            ;
*   Determine final splits for Very High Intensity Rehab residents           ;
*   on the basis of ADL sum.  Accept classification into a group if CMI      ;
*   for that group is higher than previous high CMI.                         ;
                                                                             ;
IF (n_reh_v = 1)  THEN DO;




   IF     (16 <= n_adlsum  AND  n_adlsum <= 18)   THEN DO;
             IF n_cmi(18) > n_cmi_hi               THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'RVC'; n_rug_hr=18;  END;
                n_cmi_hi = n_cmi(18);                   c_rug_mx=18;       END;
   END;
   ELSE IF ( 9 <= n_adlsum  AND  n_adlsum <= 15)  THEN DO;
             IF n_cmi(19) > n_cmi_hi               THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'RVB'; n_rug_hr=19;  END;
                n_cmi_hi = n_cmi(19);                   c_rug_mx=19;       END;
   END;
   ELSE IF ( 4 <= n_adlsum  AND  n_adlsum <=  8)  THEN DO;
             IF n_cmi(20) > n_cmi_hi               THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'RVA'; n_rug_hr=20;  END;
                n_cmi_hi = n_cmi(20);                   c_rug_mx=20;       END;
   END;

END;


*-------------------------------                                             ;
*Classify into High Intensity Rehab groups*****                              ;
*                                                                            ;
*   Classify if High Rehab indicators present and                            ;
*      (1) a previous hierarchical classification has not been made          ;
*          (indicated by n_cmi_hi being at a default negative value)         ;
*   or (2) yields a higher rate for index maximization.                      ;
*                                                                            ;
*                                                                            ;
*   Determine final splits for High Intensity Rehab residents                ;
*   on the basis of ADL sum.  Accept classification into a group if CMI      ;
*   for that group is higher than previous high CMI.                         ;

IF (n_reh_h = 1)  THEN DO;




   IF     (13 <= n_adlsum  AND  n_adlsum <= 18)   THEN DO;
             IF n_cmi(21) > n_cmi_hi               THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'RHC'; n_rug_hr=21;  END;
                n_cmi_hi = n_cmi(21);                   c_rug_mx=21;       END;
   END;
   ELSE IF ( 8 <= n_adlsum  AND  n_adlsum <= 12)  THEN DO;
             IF n_cmi(22) > n_cmi_hi               THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'RHB'; n_rug_hr=22;  END;
                n_cmi_hi = n_cmi(22);                   c_rug_mx=22;       END;
   END;
   ELSE IF ( 4 <= n_adlsum  AND  n_adlsum <=  7)  THEN DO;
             IF n_cmi(23) > n_cmi_hi               THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'RHA'; n_rug_hr=23;  END;
                n_cmi_hi = n_cmi(23);                   c_rug_mx=23;       END;
   END;

END;


*-------------------------------                                             ;
*Classify into Medium Intensity Rehab groups*****                            ;
*                                                                            ;
*   Classify if Medium Rehab indicators present and                          ;
*      (1) a previous hierarchical classification has not been made          ;
*          (indicated by n_cmi_hi being at a default negative value)         ;
*   or (2) yields a higher rate for index maximization.                      ;
*                                                                            ;
*                                                                            ;
*   Determine final splits for Medium Intensity Rehab residents              ;
*   on the basis of ADL sum.  Accept classification into a group if CMI      ;
*   for that group is higher than previous high CMI.                         ;

IF (n_reh_m = 1)  THEN DO;




   IF     (15 <= n_adlsum  AND  n_adlsum <= 18)   THEN DO;
             IF n_cmi(24) > n_cmi_hi              THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'RMC'; n_rug_hr=24; END;
                n_cmi_hi = n_cmi(24);                  c_rug_mx=24;      END;
   END;
   ELSE IF ( 8 <= n_adlsum  AND  n_adlsum <= 14)  THEN DO;
             IF n_cmi(25) > n_cmi_hi              THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'RMB'; n_rug_hr=25; END;
                n_cmi_hi = n_cmi(25);                  c_rug_mx=25;      END;
   END;
   ELSE IF ( 4 <= n_adlsum  AND  n_adlsum <=  7)  THEN DO;
             IF n_cmi(26) > n_cmi_hi              THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'RMA'; n_rug_hr=26; END;
                n_cmi_hi = n_cmi(26);                  c_rug_mx=26;      END;
   END;

END;


*-------------------------------                                             ;
*Classify into Low Intensity Rehab groups*****                               ;
*                                                                            ;
*   Classify if Low Rehab indicators present and                             ;
*      (1) a previous hierarchical classification has not been made          ;
*          (indicated by n_cmi_hi being at a default negative value)         ;
*   or (2) yields a higher rate for index maximization.                      ;
*                                                                            ;
*                                                                            ;
*   Determine final splits for Low Intensity Rehab residents                 ;
*   on the basis of ADL sum.  Accept classification into a group if CMI      ;
*   for that group is higher than previous high CMI.                         ;

IF (n_reh_l = 1)  THEN DO;




   IF     (14 <= n_adlsum  AND  n_adlsum <= 18)   THEN DO;
             IF n_cmi(27) > n_cmi_hi              THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'RLB'; n_rug_hr=27;  END;
                n_cmi_hi = n_cmi(27) ;                 c_rug_mx=27;       END;
   END;
   ELSE IF ( 4 <= n_adlsum  AND  n_adlsum <= 13)  THEN DO;
             IF n_cmi(28) > n_cmi_hi              THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'RLA'; n_rug_hr=28; END;
                n_cmi_hi = n_cmi(28);                  c_rug_mx=28;      END;
   END;

END;


*-------------------------------                                             ;
*Classify into Extensive Care Groups*****                                    ;
*                                                                            ;
*To be classified as Extensive Care a resident must qualify on the           ;
*    basis of having Extensive Care clinical indicators (n_ext = 1)  and     ;
*    an ADL sum of 7 or more  and                                            ;
*      (1) a previous hierarchical classification has not been made          ;
*          (indicated by n_cmi_hi being at a default negative value)         ;
*   or (2) yields a higher rate for index maximization.                      ;
*                                                                            ;
*    Note that residents who have Extensive Care clinical indicators but     ;
*    have too low an ADL score (6 or less) are classified as Special Care    ;
*    rather than Extensive Care.                                             ;
*                                                                            ;
*Split into Extensive Care groups is based on a count (n_ext_ct) of other    ;
*   hierarchy category qualifications plus existence of                      ;
*   parenteral/IV feeding (k5a) and IV medications (p1ac).  Accept           ;
*   classification into a group if CMI for that group is higher than         ;
*   previous high CMI.                                                       ;

IF  (n_ext = 1  AND  n_adlsum >=7)  THEN DO;



   n_ext_ct = n_spec + n_clin + n_impair;
   IF   k5a = '1'  THEN
      n_ext_ct = n_ext_ct + 1;

   IF   p1ac= '1'  THEN
      n_ext_ct = n_ext_ct + 1;


   IF     (4 <= n_ext_ct  AND  n_ext_ct <= 5)     THEN DO;
             IF n_cmi(29) > n_cmi_hi              THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'SE3'; n_rug_hr=29; END;
                n_cmi_hi = n_cmi(29);                  c_rug_mx=29;      END;
   END;
   ELSE IF (2 <= n_ext_ct  AND  n_ext_ct <= 3)    THEN DO;
             IF n_cmi(30) > n_cmi_hi              THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'SE2'; n_rug_hr=30; END;
                n_cmi_hi = n_cmi(30);                  c_rug_mx=30;      END;
   END;
   ELSE IF (0 <= n_ext_ct  AND  n_ext_ct <= 1)    THEN DO;
             IF n_cmi(31) > n_cmi_hi              THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'SE1'; n_rug_hr=31; END;
                n_cmi_hi = n_cmi(31);                  c_rug_mx=31;      END;
   END;

END;


*-------------------------------                                             ;
*Classify into Special Care Groups******                                     ;
*                                                                            ;
*To be classified as Special Care a resident must satisfy one of the         ;
*   three following conditions:                                              ;
*   1. The resident has both Special Care clinical indicators (n_spec = 1)   ;
*      and an ADL sum of 7 or more, regardless of calculation method.        ;
*   2. The calculation method is Hierarchical and the resident has both      ;
*      Extensive Care indicators (n_ext = 1) and an ADL sum of 6 or less.    ;
*   3. The calculation method is Index Maximizing and the resident           ;
*      has Extensive Care clinical indicators (n_ext = 1) with               ;
*      any ADL sum.                                                          ;
*                                                                            ;
*   Classify if one of these 3 conditions present and                        ;
*      (1) a previous hierarchical classification has not been made          ;
*          (indicated by n_cmi_hi being at a default negative value)         ;
*   or (2) yields a higher rate for index maximization.                      ;
*                                                                            ;
*                                                                            ;
*   Note that residents who have Special Care clinical indicators but        ;
*   have too low an ADL score (6 or less) are classified as Clinically       ;
*   Complex rather than Special Care.                                        ;
*                                                                            ;
*Split into Special Care groups is based on ADL sum.  Accept classification  ;
*   into a group if CMI for that group is higher than previous high CMI.     ;

IF  ((n_spec = 1  AND  n_adlsum >= 7)  OR  n_ext = 1)  THEN DO;




   IF     (17 <= n_adlsum  AND  n_adlsum <= 18)   THEN DO;
             IF n_cmi(32) > n_cmi_hi              THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'SSC';  n_rug_hr=32;  END;
                n_cmi_hi = n_cmi(32);                   c_rug_mx=32;       END;
   END;
   ELSE IF (15 <= n_adlsum  AND  n_adlsum <= 16)  THEN DO;
             IF n_cmi(33) > n_cmi_hi              THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'SSB'; n_rug_hr=33; END;
                n_cmi_hi = n_cmi(33);                  c_rug_mx=33;      END;
   END;
   ELSE IF ( 4 <= n_adlsum  AND  n_adlsum <= 14)  THEN DO;
             IF n_cmi(34) > n_cmi_hi              THEN DO;
                IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'SSA'; n_rug_hr=34; END;
                n_cmi_hi = n_cmi(34);                  c_rug_mx=34;      END;
   END;

END;


*-------------------------------                                             ;
*Classify into Clinically Complex Groups*******                              ;
*To be classified as Clinically Complex a resident must satisfy one of the   ;
*   four following conditions:                                               ;
*   1. The resident has Clinically Complex clinical indicators (n_clin = 1), ;
*      regardless of calculation method.                                     ;
*   2. The calculation method is Hierarchical and the resident has both      ;
*      Special Care indicators (n_spec = 1) and an ADL sum of 6 or less.     ;
*   3. The calculation method is Index Maximizing and the resident           ;
*      has Special Care clinical indicators (n_spec = 1) with                ;
*      any ADL sum.                                                          ;
*   4. The calculation method is Index Maximizing and the resident           ;
*      has Extensive Care clinical indicators (n_ext = 1) with               ;
*      any ADL sum.                                                          ;
*                                                                            ;
*   Classify if one of these 4 conditions present and                        ;
*      (1) a previous hierarchical classification has not been made          ;
*          (indicated by n_cmi_hi being at a default negative value)         ;
*   or (2) yields a higher rate for index maximization.                      ;
*                                                                            ;
*                                                                            ;
*Split into Clinically Complex groups is based on ADL sum and depression.    ;
*   Accept classification into a group if CMI for that group is higher       ;
*   than previous high CMI.                                                  ;

IF  (n_clin = 1  OR  n_spec = 1  OR  n_ext = 1)  THEN DO;




   IF     (17 <= n_adlsum  AND  n_adlsum <= 18)   THEN DO;
             IF n_depres = 1                      THEN DO;
                IF n_cmi(35) > n_cmi_hi           THEN DO;
                   IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'CC2'; n_rug_hr=35; END;
                   n_cmi_hi = n_cmi(35);                  c_rug_mx=35;      END;
             END;
             ELSE
                IF n_cmi(36) > n_cmi_hi           THEN DO;
                   IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'CC1'; n_rug_hr=36; END;
                   n_cmi_hi = n_cmi(36);                  c_rug_mx=36;      END;

   END;
   ELSE IF (12 <= n_adlsum  AND  n_adlsum <= 16)  THEN DO;
             IF n_depres = 1                      THEN DO;
                IF n_cmi(37) > n_cmi_hi           THEN DO;
                   IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'CB2'; n_rug_hr=37; END;
                   n_cmi_hi = n_cmi(37);                  c_rug_mx=37;      END;
             END;
             ELSE
                IF n_cmi(38) > n_cmi_hi           THEN DO;
                   IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'CB1'; n_rug_hr=38; END;
                   n_cmi_hi = n_cmi(38);                  c_rug_mx=38;      END;

   END;
   ELSE IF ( 4 <= n_adlsum  AND  n_adlsum <= 11)  THEN DO;
             IF n_depres = 1                      THEN DO;
                IF n_cmi(39) > n_cmi_hi           THEN DO;
                   IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'CA2'; n_rug_hr=39; END;
                   n_cmi_hi = n_cmi(39);                  c_rug_mx=39;      END;
             END;
             ELSE
                IF n_cmi(40) > n_cmi_hi           THEN DO;
                   IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'CA1'; n_rug_hr=40; END;
                   n_cmi_hi = n_cmi(40);                  c_rug_mx=40;      END;

   END;

END;


*-------------------------------                                             ;
*Classify into Cognitive Groups*****                                         ;
*                                                                            ;
*To be classified as Cognitive Impairment the resident has Cognitive         ;
*   Impairment indicators (n_impair = 1)  and an ADL sum of 10 or less  and  ;
*      (1) a previous hierarchical classification has not been made          ;
*          (indicated by n_cmi_hi being at a default negative value)         ;
*   or (2) yields a higher rate for index maximization.                      ;
*                                                                            ;
*                                                                            ;
*Split into Impaired Cognitive groups is based on ADL sum and nursing        ;
*   rehab count (n_nrsum6).  Accept classification into a group if CMI       ;
*   for that group is higher than previous high CMI.                         ;

IF  (n_impair = 1  AND  4 <= n_adlsum  AND  n_adlsum <= 10)  THEN DO;




   IF      ( 6 <= n_adlsum  AND  n_adlsum <= 10)  THEN DO;
             IF n_nrsum6 >= 2                     THEN DO;
                IF n_cmi(41) > n_cmi_hi           THEN DO;
                   IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'IB2'; n_rug_hr=41; END;
                   n_cmi_hi = n_cmi(41);                  c_rug_mx=41;      END;
             END;
             ELSE
                IF n_cmi(42) > n_cmi_hi           THEN DO;
                   IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'IB1'; n_rug_hr=42; END;
                   n_cmi_hi = n_cmi(42);                  c_rug_mx=42;      END;

   END;
   ELSE IF ( 4 <= n_adlsum  AND  n_adlsum <=  5)  THEN DO;
             IF n_nrsum6 >= 2                     THEN DO;
                IF n_cmi(43) > n_cmi_hi           THEN DO;
                   IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'IA2'; n_rug_hr=43; END;
                   n_cmi_hi = n_cmi(43);                  c_rug_mx=43;      END;
             END;
             ELSE
                IF n_cmi(44) > n_cmi_hi           THEN DO;
                   IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'IA1'; n_rug_hr=44; END;
                   n_cmi_hi = n_cmi(44);                  c_rug_mx=44;      END;

   END;

END;


*-------------------------------                                             ;
*Classify into Behavioral Problems Groups******                             ;
*                                                                            ;
*To be classified as Behavior Problems the resident has Behavior             ;
*   Problems indicators (n_behav = 1)  and an ADL sum of 10 or less          ;
*      (1) a previous hierarchical classification has not been made          ;
*          (indicated by n_cmi_hi being at a default negative value)         ;
*   or (2) yields a higher rate for index maximization.                      ;
*                                                                            ;
*                                                                            ;
*Split into Behavior Problems groups is based on ADL sum and nursing         ;
*   rehab count (n_nrsum6).  Accept classification into a group if CMI       ;
*   for that group is higher than previous high CMI.                         ;

IF  (n_behav = 1  AND  4 <= n_adlsum  AND  n_adlsum <= 10)  THEN DO;




   IF     ( 6 <= n_adlsum  AND  n_adlsum <= 10)   THEN DO;
             IF n_nrsum6 >= 2                     THEN DO;
                IF n_cmi(45) > n_cmi_hi           THEN DO;
                   IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'BB2'; n_rug_hr=45; END;
                   n_cmi_hi = n_cmi(45);                  c_rug_mx=45;      END;
             END;
             ELSE
                IF n_cmi(46) > n_cmi_hi           THEN DO;
                   IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'BB1'; n_rug_hr=46; END;
                   n_cmi_hi = n_cmi(46);                  c_rug_mx=46;      END;

   END;
   ELSE IF ( 4 <= n_adlsum  AND  n_adlsum <=  5)  THEN DO;
             IF n_nrsum6 >= 2                     THEN DO;
                IF n_cmi(47) > n_cmi_hi           THEN DO;
                   IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'BA2'; n_rug_hr=47; END;
                   n_cmi_hi = n_cmi(47);                  c_rug_mx=47;      END;
             END;
             ELSE
                IF n_cmi(48) > n_cmi_hi           THEN DO;
                   IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'BA1'; n_rug_hr=48; END;
                   n_cmi_hi = n_cmi(48);                  c_rug_mx=48;      END;

   END;

END;


*-------------------------------                                             ;
*Classify into Physical Groups********                                       ;
*   A resident is classified as reduced Physical Function if                 ;
*      (1) a previous hierarchical classification has not been made          ;
*          (indicated by n_cmi_hi being at a default negative value)         ;
*   or (2) yields a higher rate for index maximization.                      ;
*                                                                            ;
*                                                                            ;
*Split into Physical Function groups is based on ADL sum and nursing         ;
*   rehab count (n_nrsum6).  Accept classification into a group if CMI       ;
*   for that group is higher than previous high CMI.                         ;





   IF     (16 <= n_adlsum  AND  n_adlsum <= 18)   THEN DO;
             IF n_nrsum6 >= 2                     THEN DO;
                IF n_cmi(49) > n_cmi_hi           THEN DO;
                   IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'PE2'; n_rug_hr=49; END;
                   n_cmi_hi = n_cmi(49);                  c_rug_mx=49;      END;
             END;
             ELSE
                IF n_cmi(50) > n_cmi_hi           THEN DO;
                   IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'PE1'; n_rug_hr=50; END;
                   n_cmi_hi = n_cmi(50);                  c_rug_mx=50;      END;

   END;

   ELSE IF (11 <= n_adlsum  AND  n_adlsum <= 15)  THEN DO;
             IF n_nrsum6 >= 2                     THEN DO;
                IF n_cmi(51) > n_cmi_hi           THEN DO;
                   IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'PD2'; n_rug_hr=51; END;
                   n_cmi_hi = n_cmi(51);                  c_rug_mx=51;      END;
             END;
             ELSE
                IF n_cmi(52) > n_cmi_hi           THEN DO;
                   IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'PD1'; n_rug_hr=52; END;
                   n_cmi_hi = n_cmi(52);                  c_rug_mx=52;      END;

   END;

   ELSE IF ( 9 <= n_adlsum  AND  n_adlsum <= 10)  THEN DO;
             IF n_nrsum6 >= 2                     THEN DO;
                IF n_cmi(53) > n_cmi_hi           THEN DO;
                   IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'PC2'; n_rug_hr=53; END;
                   n_cmi_hi = n_cmi(53);                  c_rug_mx=53;      END;
             END;
             ELSE
                IF n_cmi(54) > n_cmi_hi           THEN DO;
                   IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'PC1'; n_rug_hr=54; END;
                   n_cmi_hi = n_cmi(54);                  c_rug_mx=54;      END;

   END;

   ELSE IF ( 6 <= n_adlsum  AND  n_adlsum <=  8 ) THEN DO;
             IF n_nrsum6 >= 2                     THEN DO;
                IF n_cmi(55) > n_cmi_hi           THEN DO;
                   IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'PB2'; n_rug_hr=55; END;
                   n_cmi_hi = n_cmi(55);                  c_rug_mx=55;      END;
             END;
             ELSE
                IF n_cmi(56) > n_cmi_hi           THEN DO;
                   IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'PB1'; n_rug_hr=56; END;
                   n_cmi_hi = n_cmi(56);                  c_rug_mx=56;      END;

   END;

   ELSE IF ( 4 <= n_adlsum  AND  n_adlsum <=  5 ) THEN DO;
             IF n_nrsum6 >= 2                     THEN DO;
          IF n_cmi(57) > n_cmi_hi           THEN DO;
             IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'PA2'; n_rug_hr=57;END;
               n_cmi_hi = n_cmi(57);                  c_rug_mx=57; END;
             END;
             ELSE
         IF n_cmi(58) > n_cmi_hi           THEN DO;
             IF n_cmi_hi < 0 THEN DO; c_rug_hr= 'PA1'; n_rug_hr=58; END;
             n_cmi_hi = n_cmi(58);                  c_rug_mx=58;    END;

   END;




*RUG-III Classification complete  ;

   data _null_;
   set temp1;
   put aa5a c_rug_hr n_adlsum n_cmi_hi n_no ;
   file outfile;
   put aa5a c_rug_hr n_adlsum n_cmi_hi n_no ;
      endsas;
proc freq data=temp1;
 table
 aa8b b1 b2a b4 c4 e1a e1b e1c e1d e1e e1f e1g e1h e1i e1j e1k e1l e1m
      e1n e1o e1p e4aa e4ba e4ca e4da e4ea g1aa g1ab g1ba g1bb g1ha g1ia
      g1ib h3a h3b i1a i1r i1s i1v i1w i1z i2e i2g j1c j1e j1h  j1i j1j
      j1o k3a k5a k5b k6a k6b m1a m1b m1c m1d m2a m4b m4c m4g m5a m5b
      m5c m5d m5e m5f m5g m5h m6b m6c m6f n1a n1b n1c o3 p1aa p1ab p1ac
      p1ag p1ah p1ai p1aj p1ak p1al p1baa p1bab p1bba p1bbb p1bca p1bcb
      p1bda p3a p3b p3c p3d p3e p3f p3g p3h p3i p3j p7 p8 t1b t1c t1d;


  proc contents data=temp1;
  proc univariate data=temp1;
